/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.codeassist;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.library.Completion.Ada.Ada_Completion_Manager;
import com.adacore.gnatbench.library.Completion.Ada.Constructs_Extractor.Constructs_Extractor_Package;
import com.adacore.gnatbench.library.Completion.Completion_Iterator;
import com.adacore.gnatbench.library.Completion.Completion_List;
import com.adacore.gnatbench.library.Completion.Completion_Proposal;
import com.adacore.gnatbench.library.Completion.Completion_Resolver;
import com.adacore.gnatbench.library.Language.Tree.Database.Construct_Database;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.jni.AdaString;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AdaCompletionProcessor
implements IContentAssistProcessor {
    AdaEditor fEditor;

    public AdaCompletionProcessor(AdaEditor editor) {
        this.fEditor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] iCompletionProposalArray;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            AdaDocumentBuffer buffer = this.fEditor.getDocumentBuffer();
            Virtual_File currentFile = VFS_Package.Create((AdaString)new AdaString(buffer.getBaseLocation().getAdaFile().getOSPath()));
            Ada_Completion_Manager manager = new Ada_Completion_Manager();
            Completion_Resolver resolver = Constructs_Extractor_Package.New_Construct_Completion_Resolver((Construct_Database)GNATbenchKernel.getDefault().fConstructDatabase, (Virtual_File)currentFile, (AdaString)buffer.getAdaString());
            manager.Register_Resolver(resolver);
            Completion_List list = manager.Get_Initial_Completion_List(manager.Create_Context(buffer.getAdaString(), offset), true);
            Completion_Iterator it = list.First();
            LinkedList<AdaCompletionProposal> resultList = new LinkedList<AdaCompletionProposal>();
            int completedLength = list.Get_Completed_String().toString().length();
            int total = 0;
            while (!it.At_End() && total < 100) {
                resultList.add(new AdaCompletionProposal(it.Get_Proposal(), offset - completedLength, completedLength));
                it.Next();
                ++total;
            }
            ICompletionProposal[] result = new ICompletionProposal[resultList.size()];
            int i = 0;
            Iterator iter = resultList.iterator();
            while (iter.hasNext()) {
                ICompletionProposal element;
                result[i] = element = (ICompletionProposal)iter.next();
                ++i;
            }
            iCompletionProposalArray = result;
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return iCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '('};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    class AdaCompletionProposal
    implements ICompletionProposal {
        Completion_Proposal fProposal;
        int fCompletedLength;
        int fFrom;

        public AdaCompletionProposal(Completion_Proposal proposal, int from, int completedLength) {
            this.fProposal = proposal;
            this.fFrom = from;
            this.fCompletedLength = completedLength;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void apply(IDocument document) {
            int semDepth = LibrarySemaphore.startGPSWork();
            try {
                try {
                    String completionStr = this.fProposal.Get_Completion().toString();
                    document.replace(this.fFrom, this.fCompletedLength, completionStr);
                    AdaCompletionProcessor.this.fEditor.getSourceViewerPublic().getTextWidget().setCaretOffset(this.fFrom + this.fProposal.Get_Caret_Offset());
                }
                catch (BadLocationException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            {
                Object var4_7 = null;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getAdditionalProposalInfo() {
            String res;
            int semDepth = LibrarySemaphore.startGPSWork();
            try {
                res = this.fProposal.Get_Documentation().toString();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return res.replaceAll("\n", "\n<br/>");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            String string;
            int semDepth = LibrarySemaphore.startGPSWork();
            try {
                string = this.fProposal.Get_Label().toString();
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return string;
        }

        public Image getImage() {
            return AdaConstruct.getImage((int)this.fProposal.Get_Category(), (int)this.fProposal.Get_Visibility());
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }
}

