/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.buildtarget;

import com.adacore.gnatbench.core.make.IMakefileTarget;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.buildtarget.MakefileContentProvider;
import com.adacore.gnatbench.ui.buildtarget.MakefileLabelProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TargetListViewer {
    protected static final String BUILD_TARGET_ICON = "build_target";
    protected TableViewer tableViewer;
    protected StructuredViewer viewer;
    protected IMakefileTarget fSelectedTarget;
    protected IContainer container;

    public TargetListViewer(IContainer container) {
        this.container = container;
        if (GNATbenchUIPlugin.getDefault().getImage(BUILD_TARGET_ICON) == null) {
            GNATbenchUIPlugin.getDefault().addImage(BUILD_TARGET_ICON, "/img/", "make_target.gif");
        }
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style) {
        this.tableViewer = new TableViewer(parent, 2052);
        Table table = (Table)this.tableViewer.getControl();
        TableLayout layout = new TableLayout();
        table.setLinesVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText("Target Name");
        tc.setImage(GNATbenchUIPlugin.getDefault().getImage(BUILD_TARGET_ICON));
        tc.setAlignment(0x1000000);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(75));
        tc = new TableColumn(table, 0, 1);
        tc.setText("Target Description");
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TargetListViewer.this.selectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new MakefileContentProvider());
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IMakefileTarget;
            }
        });
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MakefileLabelProvider());
        this.tableViewer.setInput((Object)this.container);
        return this.tableViewer;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.fSelectedTarget = (IMakefileTarget)selection.getFirstElement();
    }

    public void setSelectedTarget(IMakefileTarget target) {
        this.fSelectedTarget = target;
        if (this.tableViewer != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedTarget), false);
        }
    }

    public IMakefileTarget getSelectedTarget() {
        return this.fSelectedTarget;
    }

    public void createControl(Composite parent, int style, int span) {
        this.viewer = this.createStructuredViewer(parent, style);
        Control control = this.viewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        if (this.viewer != null && this.fSelectedTarget != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedTarget));
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }
}

