/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.buildtarget;

import com.adacore.gnatbench.core.make.IMakefileTarget;
import com.adacore.gnatbench.ui.buildtarget.TargetListViewer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildTargetDialog
extends Dialog {
    protected TargetListViewer targetView;
    protected IContainer container;

    public BuildTargetDialog(Shell shell, IContainer container) {
        super(shell);
        this.container = container;
        this.targetView = new TargetListViewer(this.container);
    }

    public void setTarget(IMakefileTarget target) {
        this.targetView.setSelectedTarget(target);
    }

    public IMakefileTarget getTarget() {
        return this.targetView.getSelectedTarget();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Build Selected Target");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Build", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(this.targetView.getSelectedTarget() != null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label title = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        title.setText("Makefile Targets in project [" + this.container.getFullPath().toString().substring(1) + "]");
        this.targetView.createControl(composite, 0, 2);
        gd = (GridData)this.targetView.getControl().getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(100);
        this.targetView.getControl().setLayoutData((Object)gd);
        this.targetView.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuildTargetDialog.this.okPressed();
            }
        });
        this.targetView.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildTargetDialog.this.getButton(0).setEnabled(BuildTargetDialog.this.targetView.getSelectedTarget() != null);
            }
        });
        return composite;
    }
}

