/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.builder;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.builder.IGNATbenchBuildListener;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.compiler.CompilerMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GNATbenchBuildAnnotate
implements IGNATbenchBuildListener {
    final String noteworthy = "(.*?):([0-9]+):([0-9]+:)? ((warning: )?.*)";

    public void compilationCompleted(IProject project, AdaFile[] compiledFiles, String[] messages, IProgressMonitor monitor) {
        boolean shouldShowProblemsView = false;
        int i = 0;
        while (i < compiledFiles.length) {
            if (compiledFiles[i] != null) {
                this.cleanMarkers(compiledFiles[i].getFile());
            }
            ++i;
        }
        int k = 0;
        while (k < messages.length) {
            if (monitor.isCanceled()) break;
            if (Pattern.matches("(.*?):([0-9]+):([0-9]+:)? ((warning: )?.*)", messages[k])) {
                shouldShowProblemsView = true;
                new CompilerMessage(project, messages[k], k);
            }
            ++k;
        }
        if (shouldShowProblemsView) {
            this.showProblemsView();
        }
    }

    public void cleanMarkers(IFile file) {
        try {
            IMarker[] markers = file.findMarkers("com.adacore.gnatbench.core.AdaErrorMarker", true, 2);
            HashMap resourceMap = new HashMap();
            int i = 0;
            while (i < markers.length) {
                resourceMap.put(markers[i].getResource(), null);
                markers[i].delete();
                ++i;
            }
            Iterator iter = resourceMap.keySet().iterator();
            while (iter.hasNext()) {
                IResource resource = (IResource)iter.next();
                AdaEditor editor = (AdaEditor)GNATbenchCorePlugin.getDefault().getEditor((IFile)resource);
                if (editor == null) continue;
                editor.updateAnnotations();
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    protected void showProblemsView() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    p.showView("org.eclipse.ui.views.ProblemView");
                }
                catch (PartInitException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
            }
        });
    }
}

