/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.builder;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractIncrementalBuilderAction
extends ActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IProject project = null;

    protected abstract int targetName();

    protected boolean preBuildSteps(IProject project) {
        return true;
    }

    protected void postBuildSteps(IProject project) {
    }

    public void run(IAction action) {
        if (this.project != null) {
            try {
                boolean OK = this.preBuildSteps(this.project);
                if (!OK) {
                    return;
                }
                this.project.build(this.targetName(), null);
                this.postBuildSteps(this.project);
            }
            catch (Exception e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object obj;
        boolean enabled;
        boolean bl = enabled = this.project != null;
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            this.project = (IProject)obj;
            enabled = true;
        }
        action.setEnabled(enabled);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void init(IWorkbenchWindow window) {
    }
}

