/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.ui.browsing.MatchTag;
import java.util.Iterator;
import java.util.LinkedList;

public class SearchNode {
    private SearchNode fParent;
    private LinkedList fChildren = new LinkedList();
    protected LinkedList fMatches = new LinkedList();
    private boolean fInDispose = false;

    public SearchNode(SearchNode parent) {
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.fChildren.add(this);
        }
    }

    public SearchNode getParent() {
        return this.fParent;
    }

    public void dispose() {
        if (this.fInDispose) {
            return;
        }
        this.fInDispose = true;
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            SearchNode element = (SearchNode)iter.next();
            element.dispose();
        }
        if (this.fParent != null) {
            this.fParent.removeChild(this);
            if (this.fParent.getChildren().size() == 0) {
                this.fParent.dispose();
            }
        }
        this.fInDispose = false;
        this.hide();
    }

    private void removeChild(SearchNode node) {
        if (this.fInDispose) {
            return;
        }
        this.fChildren.remove(node);
    }

    public LinkedList getChildren() {
        return this.fChildren;
    }

    public void addMatch(MatchTag match) {
        this.fMatches.add(match);
    }

    public void hide() {
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            element.hide();
        }
    }

    public void show() {
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            element.show();
        }
    }

    public MatchTag getMatchAt(int offset) {
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            if (element.getOffset() != offset) continue;
            return element;
        }
        return null;
    }

    public LinkedList getMatches() {
        return this.fMatches;
    }
}

