/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.browsing.SearchNode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class MatchTag {
    private AdaLocation fLocation;
    private IMarker fMarker;
    private String fName;
    private int fOffset;
    SearchNode fNode;

    public MatchTag(AdaLocation location, String name, int offset, SearchNode node) {
        this.fLocation = location;
        this.fName = name;
        this.fOffset = offset;
        this.fNode = node;
    }

    public int getLine() {
        return this.fLocation.getEclipseLine();
    }

    public int getColumn() {
        return this.fLocation.getEclipseColumn();
    }

    public String getName() {
        return this.fName;
    }

    public IMarker getMarker() {
        return this.fMarker;
    }

    public SearchNode getNode() {
        return this.fNode;
    }

    private void createMarker() {
        this.fMarker = GNATbenchUIPlugin.getDefault().createMarker(this.fLocation.getAdaFile(), "com.adacore.gnatbench.core.AdaLocationMarker");
        if (this.fMarker != null) {
            try {
                int offset = this.fOffset;
                this.fMarker.setAttribute("charStart", offset);
                this.fMarker.setAttribute("charEnd", offset + this.fLocation.getLength());
                this.fMarker.setAttribute("AdaLocationMarker.Column", this.fLocation.getEclipseColumn());
                this.fMarker.setAttribute("lineNumber", this.fLocation.getEclipseLine());
                this.fMarker.setAttribute("AdaLocationMarker.Text", (Object)this.fName);
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
    }

    private void deleteMarker() {
        if (this.fMarker != null) {
            try {
                this.fMarker.delete();
                this.fMarker = null;
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
    }

    public void show() {
        this.createMarker();
        GNATbenchUIPlugin.getDefault().refreshAnnotations(this.fLocation.getAdaFile().getFile());
    }

    public void hide() {
        this.deleteMarker();
        GNATbenchUIPlugin.getDefault().refreshAnnotations(this.fLocation.getAdaFile().getFile());
    }

    public AdaLocation getLocation() {
        return this.fLocation;
    }

    public int getOffset() {
        return this.fOffset;
    }
}

