/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.gpswrappers.Entity;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class AdaXrefsHyperlinks
implements MouseMoveListener,
MouseListener {
    private StyleRange fOldStyle = null;
    private AdaEditor fEditor;
    private Cursor fCursorHand = null;
    private Cursor fRegularCursor = null;
    private boolean fEntityHighlighted = false;

    public AdaXrefsHyperlinks(AdaEditor Editor) {
        this.fEditor = Editor;
    }

    public void setHighlighted(boolean state) {
        if (state != this.fEntityHighlighted) {
            this.fEntityHighlighted = state;
            if (this.fCursorHand == null) {
                this.fCursorHand = new Cursor((Device)this.fEditor.getSourceViewerPublic().getTextWidget().getDisplay(), 21);
                this.fRegularCursor = new Cursor((Device)this.fEditor.getSourceViewerPublic().getTextWidget().getDisplay(), 19);
            }
            if (this.fEntityHighlighted) {
                this.fEditor.getSourceViewerPublic().getTextWidget().setCursor(this.fCursorHand);
            } else {
                this.fEditor.getSourceViewerPublic().getTextWidget().setCursor(this.fRegularCursor);
            }
        }
    }

    public AdaEntityReference getCorrectEntity(int offset) {
        String contentType;
        try {
            IDocumentExtension3 extension = (IDocumentExtension3)this.fEditor.getSourceViewerPublic().getDocument();
            contentType = extension.getContentType("__ada_gnatbench_partitioning", offset, false);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (BadPartitioningException badPartitioningException) {
            return null;
        }
        if (contentType != "__dftl_partition_content_type") {
            return null;
        }
        AdaEntityReference entity = this.fEditor.getDocumentBuffer().getEntity(offset);
        if (!entity.isRegularIdentifier()) {
            return null;
        }
        return entity;
    }

    public void mouseMove(MouseEvent e) {
        if (e.getSource() instanceof StyledText) {
            int widgetOffset;
            int offset;
            StyledText text = (StyledText)e.getSource();
            if (this.fOldStyle != null) {
                text.setStyleRange(this.fOldStyle);
                this.fOldStyle = null;
            }
            if ((e.stateMask & 0x40000) == 0) {
                this.setHighlighted(false);
                return;
            }
            try {
                widgetOffset = offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                if (this.fEditor.getSourceViewerPublic() instanceof ProjectionViewer) {
                    offset = ((ProjectionViewer)this.fEditor.getSourceViewerPublic()).widgetOffset2ModelOffset(offset);
                }
                if (offset >= this.fEditor.getDocumentBuffer().getContent().length()) {
                    offset = this.fEditor.getDocumentBuffer().getContent().length() - 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setHighlighted(false);
                return;
            }
            AdaEntityReference entity = this.getCorrectEntity(offset);
            if (entity == null) {
                this.setHighlighted(false);
                return;
            }
            int offsetBegin = entity.getOffset();
            int offsetEnd = entity.getOffset() + entity.getLocation().getLength() - 1;
            if (this.fEditor.getSourceViewerPublic() instanceof ProjectionViewer) {
                offsetBegin = ((ProjectionViewer)this.fEditor.getSourceViewerPublic()).modelOffset2WidgetOffset(offsetBegin);
                offsetEnd = ((ProjectionViewer)this.fEditor.getSourceViewerPublic()).modelOffset2WidgetOffset(offsetEnd);
            }
            if (entity.getLocation().getLength() > 0) {
                this.fOldStyle = text.getStyleRangeAtOffset(widgetOffset);
                if (this.fOldStyle == null) {
                    this.fOldStyle = new StyleRange();
                }
                this.fOldStyle.start = offsetBegin;
                this.fOldStyle.length = offsetEnd - offsetBegin + 1;
                StyleRange newStyle = (StyleRange)this.fOldStyle.clone();
                newStyle.start = offsetBegin;
                newStyle.length = offsetEnd - offsetBegin + 1;
                newStyle.underline = true;
                newStyle.foreground = text.getDisplay().getSystemColor(9);
                text.setStyleRange(newStyle);
                this.setHighlighted(true);
                return;
            }
        }
        this.setHighlighted(false);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if ((e.stateMask & 0x40000) != 0) {
            int offset;
            StyledText text = (StyledText)e.getSource();
            try {
                offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                if (this.fEditor.getSourceViewerPublic() instanceof ProjectionViewer) {
                    offset = ((ProjectionViewer)this.fEditor.getSourceViewerPublic()).widgetOffset2ModelOffset(offset);
                }
                if (offset >= this.fEditor.getDocumentBuffer().getContent().length()) {
                    offset = this.fEditor.getDocumentBuffer().getContent().length() - 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            try {
                int lineNumber;
                AdaEntityReference entity = this.getCorrectEntity(offset);
                if (entity == null) {
                    return;
                }
                offset = entity.getOffset();
                if (entity == null) {
                    return;
                }
                String entityName = entity.getName();
                try {
                    lineNumber = this.fEditor.getDocumentBuffer().getDocument().getLineOfOffset(offset);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                Entity focusedEntity = new Entity(entity);
                AdaLocation spec = focusedEntity.getSpec();
                if (spec == null) {
                    return;
                }
                if (spec.getEclipseLine() == lineNumber && spec.getAdaFile().getOSPath().equals(entity.getLocation().getAdaFile().getOSPath())) {
                    IEditorPart newEditor;
                    AdaLocation body = focusedEntity.getBody();
                    if (body != null && (newEditor = GNATbenchUIPlugin.getDefault().openEditor(body)) instanceof AdaEditor) {
                        AdaEditor adaEditor = (AdaEditor)newEditor;
                        body = adaEditor.getDocumentBuffer().getClosestLocation(body, entityName);
                        adaEditor.focus(body);
                    }
                } else {
                    IEditorPart newEditor = GNATbenchUIPlugin.getDefault().openEditor(spec);
                    if (newEditor instanceof AdaEditor) {
                        AdaEditor adaEditor = (AdaEditor)newEditor;
                        spec = adaEditor.getDocumentBuffer().getClosestLocation(spec, entityName);
                        adaEditor.focus(spec);
                    }
                }
            }
            catch (PartInitException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
            }
        }
    }
}

