/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.browsing.AdaSearchResult;
import com.adacore.gnatbench.ui.browsing.ConstructNode;
import com.adacore.gnatbench.ui.browsing.FileNode;
import com.adacore.gnatbench.ui.browsing.FolderNode;
import com.adacore.gnatbench.ui.browsing.MatchTag;
import com.adacore.gnatbench.ui.browsing.ProjectNode;
import com.adacore.gnatbench.ui.browsing.SearchNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class AdaSearchView
extends AbstractTextSearchViewPage {
    public static final int DISPLAY_TABLE = 1;
    public static final int DISPLAY_TREE = 2;
    private Action fCurrentGroupMode = null;
    private int fDisplayMode;
    private SearchContentProvider fContentProvider = new SearchContentProvider();
    private StructuredViewer fViewer = null;

    protected void elementsChanged(Object[] objects) {
        if (this.getViewer() instanceof StructuredViewer) {
            StructuredViewer viewer = this.getViewer();
            viewer.refresh();
        }
    }

    protected void clear() {
        this.fContentProvider.dispose();
        if (this.fViewer != null) {
            this.fViewer.refresh();
            this.fViewer.setInput(null);
        }
    }

    public void dispose() {
        this.fContentProvider.dispose();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.fDisplayMode = 2;
        viewer.setLabelProvider((IBaseLabelProvider)new SearchLabelProvider());
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClick());
        this.fViewer = viewer;
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.fDisplayMode = 1;
        viewer.setLabelProvider((IBaseLabelProvider)new SearchLabelProvider());
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClick());
        this.fViewer = viewer;
    }

    public void gotoNextMatch() {
        super.gotoNextMatch();
        this.jumpToMatch();
    }

    public void gotoPreviousMatch() {
        super.gotoPreviousMatch();
        this.jumpToMatch();
    }

    public void jumpToMatch() {
        Match match = this.getCurrentMatch();
        if (match == null) {
            return;
        }
        SearchNode node = (SearchNode)match.getElement();
        MatchTag matchTag = node.getMatchAt(match.getOffset());
        AdaLocation location = matchTag.getLocation();
        try {
            IEditorPart editor = GNATbenchUIPlugin.getDefault().openEditor(location);
            if (editor instanceof AdaEditor) {
                AdaEditor adaEditor = (AdaEditor)editor;
                location = matchTag.getMarker() != null ? adaEditor.getUpdatedLocation(matchTag.getMarker()) : adaEditor.getDocumentBuffer().getClosestLocation(location, matchTag.getName());
                location.setLength(matchTag.getName().length());
                adaEditor.focus(location);
                this.setFocus();
            }
        }
        catch (PartInitException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    public void jumpToSelection() {
        Object node = ((StructuredSelection)this.fViewer.getSelection()).getFirstElement();
        if (node instanceof FileNode) {
            FileNode file = (FileNode)node;
            AdaLocation location = AdaLocation.fromEclipse((AdaFile)file.getAdaFile(), (int)0, (int)0);
            try {
                GNATbenchUIPlugin.getDefault().openEditor(location);
            }
            catch (PartInitException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        } else if (node instanceof ConstructNode) {
            ConstructNode construct = (ConstructNode)node;
            AdaLocation location = construct.getConstruct().getLocation();
            try {
                GNATbenchUIPlugin.getDefault().openEditor(location);
            }
            catch (PartInitException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
    }

    protected void handleOpen(OpenEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof FolderNode || selection.getFirstElement() instanceof ProjectNode) {
            super.handleOpen(event);
        }
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.fDisplayMode == 2) {
            this.fCurrentGroupMode = new PackageGroup();
            this.fCurrentGroupMode.setChecked(true);
            tbm.appendToGroup("group.viewerSetup", (IContributionItem)new Separator());
            tbm.appendToGroup("group.viewerSetup", (IAction)new ProjectGroup());
            tbm.appendToGroup("group.viewerSetup", (IAction)new FileGroup());
            tbm.appendToGroup("group.viewerSetup", (IAction)this.fCurrentGroupMode);
        }
    }

    private boolean isRootNode(SearchNode node) {
        if (node.getParent() == null) {
            return true;
        }
        if (this.fDisplayMode == 1) {
            return true;
        }
        if (this.fDisplayMode == 2) {
            if (this.fCurrentGroupMode instanceof FileGroup) {
                return node instanceof FileNode;
            }
            if (this.fCurrentGroupMode instanceof ProjectGroup) {
                return node instanceof ProjectNode;
            }
            if (this.fCurrentGroupMode instanceof PackageGroup) {
                return node instanceof ConstructNode && !(node.getParent() instanceof ConstructNode);
            }
        }
        return false;
    }

    private class ProjectGroup
    extends Action {
        public ProjectGroup() {
            super("Group By Project", 2);
            this.setToolTipText("Group By Project");
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "prj_mode.gif");
        }

        public void run() {
            AdaSearchView.this.fCurrentGroupMode.setChecked(false);
            AdaSearchView.this.fCurrentGroupMode = this;
            AdaSearchView.this.fCurrentGroupMode.setChecked(true);
            AdaSearchView.this.getViewer().refresh();
        }
    }

    private class FileGroup
    extends Action {
        public FileGroup() {
            super("Group By File", 2);
            this.setToolTipText("Group By File");
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "file_mode.gif");
        }

        public void run() {
            AdaSearchView.this.fCurrentGroupMode.setChecked(false);
            AdaSearchView.this.fCurrentGroupMode = this;
            AdaSearchView.this.fCurrentGroupMode.setChecked(true);
            AdaSearchView.this.getViewer().refresh();
        }
    }

    private class PackageGroup
    extends Action {
        public PackageGroup() {
            super("Group By Package", 2);
            this.setToolTipText("Group By Package");
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "package_mode.gif");
        }

        public void run() {
            AdaSearchView.this.fCurrentGroupMode.setChecked(false);
            AdaSearchView.this.fCurrentGroupMode = this;
            AdaSearchView.this.fCurrentGroupMode.setChecked(true);
            AdaSearchView.this.getViewer().refresh();
        }
    }

    private class SearchContentProvider
    implements ITreeContentProvider,
    ISearchResultListener {
        private AdaSearchResult fResults;

        private SearchContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SearchNode) {
                Object[] result = ((SearchNode)parentElement).getChildren().toArray();
                return result;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof SearchNode) {
                return ((SearchNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FileNode || element instanceof FolderNode || element instanceof ProjectNode) {
                return true;
            }
            return ((SearchNode)element).getChildren().size() > 0;
        }

        public Object[] getElements(Object inputElement) {
            this.fResults = (AdaSearchResult)((Object)inputElement);
            if (AdaSearchView.this.fDisplayMode == 1) {
                Object[] r = this.fResults.getMatchingNodes().toArray();
                return r;
            }
            if (AdaSearchView.this.fDisplayMode == 2) {
                if (AdaSearchView.this.fCurrentGroupMode instanceof FileGroup) {
                    return this.fResults.getFileNodes().toArray();
                }
                if (AdaSearchView.this.fCurrentGroupMode instanceof ProjectGroup) {
                    return this.fResults.getProjectNodes().toArray();
                }
                if (AdaSearchView.this.fCurrentGroupMode instanceof PackageGroup) {
                    return this.fResults.getPackageNodes().toArray();
                }
            }
            return new Object[0];
        }

        public void dispose() {
            if (this.fResults != null) {
                this.fResults.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.fResults != null) {
                this.fResults.removeListener(this);
                this.fResults.hide();
            }
            if (newInput instanceof AdaSearchResult) {
                this.fResults = (AdaSearchResult)((Object)newInput);
                this.fResults.show();
                this.fResults.addListener(this);
            } else {
                this.fResults = null;
            }
        }

        public void searchResultChanged(SearchResultEvent e) {
            if (e instanceof MatchEvent) {
                MatchEvent evt = (MatchEvent)e;
                if (evt.getKind() == 2) {
                    AdaSearchView.this.fViewer.refresh();
                }
            } else {
                boolean cfr_ignored_0 = e instanceof RemoveAllEvent;
            }
        }
    }

    private class SearchLabelProvider
    implements ILabelProvider {
        private static final String ICON_FOLDER = "icon_folder";
        private static final String ICON_FILE = "icon_file";
        private static final String ICON_MATCH = "icon_search";
        private static final String ICON_PROJECT = "icon_project";

        public SearchLabelProvider() {
            if (GNATbenchUIPlugin.getDefault().getImage(ICON_FOLDER) == null) {
                GNATbenchUIPlugin.getDefault().addImage(ICON_FOLDER, "/img/", "fldr_obj.gif");
                GNATbenchUIPlugin.getDefault().addImage(ICON_FILE, "/img/", "file_obj.gif");
                GNATbenchUIPlugin.getDefault().addImage(ICON_MATCH, "/img/", "searchm_obj.gif");
                GNATbenchUIPlugin.getDefault().addImage(ICON_PROJECT, "/img/", "prj_obj.gif");
            }
        }

        public Image getImage(Object element) {
            if (element instanceof FolderNode) {
                return GNATbenchUIPlugin.getDefault().getImage(ICON_FOLDER);
            }
            if (element instanceof FileNode) {
                return GNATbenchUIPlugin.getDefault().getImage(ICON_FILE);
            }
            if (element instanceof ProjectNode) {
                return GNATbenchUIPlugin.getDefault().getImage(ICON_PROJECT);
            }
            if (element instanceof ConstructNode) {
                return ((ConstructNode)element).getConstruct().getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof SearchNode) {
                if (AdaSearchView.this.isRootNode((SearchNode)element)) {
                    if (element instanceof ConstructNode) {
                        ConstructNode construct = (ConstructNode)element;
                        return String.valueOf(element.toString()) + " - " + construct.getConstruct().getLocation().getAdaFile().getOSPath();
                    }
                    if (element instanceof FileNode) {
                        FileNode file = (FileNode)element;
                        return String.valueOf(file.getName()) + " - " + file.getAdaFile().getOSPath().replaceAll("[^\\\\/]*$", "");
                    }
                }
                if (element instanceof FileNode) {
                    return ((FileNode)element).getName();
                }
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class DoubleClick
    implements IDoubleClickListener {
        private DoubleClick() {
        }

        public void doubleClick(DoubleClickEvent event) {
            AdaSearchView.this.jumpToSelection();
        }
    }
}

