/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.AdaConstructPassTroughFilter;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.AdaSimpleConstruct;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.core.browsing.AdaCodeBrowser;
import com.adacore.gnatbench.library.Language.Tree.Ada.Ada_Package;
import com.adacore.gnatbench.library.Language.Tree.Construct_Tree;
import com.adacore.gnatbench.library.Language.Tree.Construct_Tree_Iterator;
import com.adacore.gnatbench.library.Language.Tree.Database.Structured_File;
import com.adacore.gnatbench.library.Language.Tree.Tree_Package;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.browsing.AdaQueryAllReferences;
import com.adacore.gnatbench.ui.browsing.ConstructNode;
import com.adacore.gnatbench.ui.browsing.FileNode;
import com.adacore.gnatbench.ui.browsing.FolderNode;
import com.adacore.gnatbench.ui.browsing.MatchTag;
import com.adacore.gnatbench.ui.browsing.ProjectNode;
import com.adacore.gnatbench.ui.browsing.SearchNode;
import com.adacore.jni.AdaString;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;

public class AdaSearchResult
extends AbstractTextSearchResult
implements IAdaConstructFilterProvider {
    private ISearchQuery fQuery;
    private String fLabel;
    private String fSearchString;
    private SearchNode fRoot = new SearchNode(null);
    private LinkedList fMatches = new LinkedList();
    private Job fChangeStateJob;

    public AdaSearchResult(AdaQueryAllReferences query, String label, String searchString) {
        this.fQuery = query;
        this.fLabel = label;
        this.fSearchString = searchString;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public String getLabel() {
        return String.valueOf(this.fLabel) + " (" + this.fMatches.size() + " matches)";
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResults(AdaCodeBrowser.LocationIterator results, IProgressMonitor monitor) {
        monitor.beginTask("analyzing results", results.totalProgress());
        int currentProgress = 0;
        while (!results.atEnd()) {
            block7: {
                Object var14_14;
                int newProgress = results.currentProgress();
                monitor.worked(newProgress - currentProgress);
                currentProgress = newProgress;
                if (monitor.isCanceled()) break;
                AdaLocation location = results.current();
                if (location == null) break block7;
                int semDepth = LibrarySemaphore.startGPSWork();
                try {
                    Structured_File file = GNATbenchKernel.getDefault().fConstructDatabase.Get_Or_Create(VFS_Package.Create((AdaString)new AdaString(location.getAdaFile().getOSPath())), Ada_Package.Ada_Tree_Lang());
                    Construct_Tree tree = file.Get_Full_Tree();
                    Construct_Tree_Iterator iter = tree.Get_Iterator_At(location.getGPSLine(), location.getGPSColumn(), 0, 3, Tree_Package.Null_Category_Array());
                    int offset = 0;
                    offset = location.getGPSColumn() + GNATbenchKernel.getDefault().fConstructDatabase.Get_Or_Create(VFS_Package.Create((AdaString)new AdaString(location.getAdaFile().getOSPath())), Ada_Package.Ada_Tree_Lang()).Get_Offset_Of_Line(location.getGPSLine());
                    ConstructNode node = this.getOrCreateConstructNode(iter, tree, location);
                    MatchTag match = new MatchTag(location, this.getSearchString(), offset, node);
                    node.addMatch(match);
                    this.addMatch(new Match((Object)node, offset, location.getLength()));
                    match.show();
                    AdaSearchResult adaSearchResult = this;
                    synchronized (adaSearchResult) {
                        this.fMatches.add(match);
                    }
                }
                catch (Throwable throwable) {
                    var14_14 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
                {
                    var14_14 = null;
                }
                LibrarySemaphore.stopGPSWork((int)semDepth);
            }
            results.next();
        }
        monitor.done();
    }

    private ConstructNode getOrCreateConstructNode(Construct_Tree_Iterator it, Construct_Tree tree, AdaLocation loc) {
        ConstructNode node;
        while (!it.equals((Object)Tree_Package.Null_Construct_Tree_Iterator()) && it.Get_Construct().Category() >= 25) {
            it = tree.Get_Parent_Scope(it);
        }
        Construct_Tree_Iterator parent = tree.Get_Parent_Scope(it);
        AdaSimpleConstruct newConstruct = new AdaSimpleConstruct(it.Get_Construct(), loc.getAdaFile());
        if (!parent.equals((Object)Tree_Package.Null_Construct_Tree_Iterator())) {
            ConstructNode parentNode = this.getOrCreateConstructNode(parent, tree, loc);
            node = parentNode.getConstructChild(newConstruct, this);
            if (node == null) {
                node = new ConstructNode(parentNode, newConstruct);
            }
        } else {
            FileNode fileNode = this.getOrCreateFileNode(loc);
            node = fileNode.getConstructChild(newConstruct, this);
            if (node == null) {
                node = new ConstructNode(fileNode, newConstruct);
            }
        }
        return node;
    }

    public void clear() {
        this.fRoot.dispose();
        this.fMatches.clear();
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private FileNode getOrCreateFileNode(AdaLocation location) {
        String filePath = location.getAdaFile().getEclipsePath();
        IProject baseProject = location.getAdaFile().getProject();
        String[] path = filePath.split("\\\\|/");
        LinkedList currentFolders = this.fRoot.getChildren();
        SearchNode lastNode = this.fRoot;
        int currentFolderId = 0;
        while (currentFolderId < path.length - 1) {
            if (!path[currentFolderId].equals("")) {
                boolean found = false;
                Iterator iter = currentFolders.iterator();
                while (iter.hasNext()) {
                    ProjectNode project;
                    Object next = iter.next();
                    if (next instanceof FolderNode) {
                        FolderNode folder = (FolderNode)next;
                        if (!folder.getName().equals(path[currentFolderId])) continue;
                        lastNode = folder;
                        found = true;
                        break;
                    }
                    if (!(next instanceof ProjectNode) || baseProject == null || !(project = (ProjectNode)next).getName().equals(baseProject.getName())) continue;
                    lastNode = project;
                    found = true;
                    baseProject = null;
                    break;
                }
                if (!found) {
                    if (baseProject != null) {
                        lastNode = new ProjectNode(baseProject.getName(), lastNode);
                        baseProject = null;
                    } else {
                        lastNode = new FolderNode(path[currentFolderId], lastNode);
                    }
                }
                currentFolders = lastNode.getChildren();
            }
            ++currentFolderId;
        }
        Iterator iter = lastNode.getChildren().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof FileNode) || !((FileNode)element).getName().equals(path[path.length - 1])) continue;
            return (FileNode)element;
        }
        FileNode file = new FileNode(location.getAdaFile(), lastNode);
        return file;
    }

    public void refreshAnnotations() {
        LinkedList files = this.getFileNodes();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            FileNode element = (FileNode)iter.next();
            GNATbenchUIPlugin.getDefault().refreshAnnotations(element.getAdaFile().getFile());
        }
    }

    public void removeMatch(Match match) {
        if (match.getElement() instanceof SearchNode) {
            SearchNode node = (SearchNode)match.getElement();
            Iterator iter = node.getMatches().iterator();
            while (iter.hasNext()) {
                MatchTag element = (MatchTag)iter.next();
                this.fMatches.remove(element);
            }
            node.dispose();
        }
        super.removeMatch(match);
    }

    public void removeMatches(Match[] matches) {
        int i = 0;
        while (i < matches.length) {
            if (matches[i].getElement() instanceof SearchNode) {
                SearchNode node = (SearchNode)matches[i].getElement();
                Iterator iter = node.getMatches().iterator();
                while (iter.hasNext()) {
                    MatchTag element = (MatchTag)iter.next();
                    this.fMatches.remove(element);
                }
                node.dispose();
            }
            ++i;
        }
        super.removeMatches(matches);
    }

    public synchronized void show() {
        final Job previousJob = this.fChangeStateJob;
        this.fChangeStateJob = new Job("Show matches"){

            protected IStatus run(IProgressMonitor monitor) {
                if (previousJob != null) {
                    try {
                        previousJob.join();
                    }
                    catch (InterruptedException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    }
                }
                Iterator iter = AdaSearchResult.this.fMatches.iterator();
                while (iter.hasNext()) {
                    MatchTag element = (MatchTag)iter.next();
                    element.show();
                }
                return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
            }
        };
        this.fChangeStateJob.schedule();
    }

    public synchronized void hide() {
        final Job previousJob = this.fChangeStateJob;
        this.fChangeStateJob = new Job("Hide matches"){

            protected IStatus run(IProgressMonitor monitor) {
                if (previousJob != null) {
                    try {
                        previousJob.join();
                    }
                    catch (InterruptedException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    }
                }
                Iterator iter = AdaSearchResult.this.fMatches.iterator();
                while (iter.hasNext()) {
                    MatchTag element = (MatchTag)iter.next();
                    element.hide();
                }
                return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
            }
        };
        this.fChangeStateJob.schedule();
    }

    public AdaConstructFilter getFilter() {
        return new AdaConstructPassTroughFilter(){

            public boolean simpleFilter(AdaConstruct construct) {
                int category = construct.getCategory();
                return category >= 1 && category <= 17 || category == 22 || category == 23 || category == 19;
            }
        };
    }

    public synchronized LinkedList getProjectNodes() {
        LinkedList<SearchNode> result = new LinkedList<SearchNode>();
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            SearchNode current = element.getNode();
            while (current.getParent() != null && current.getParent() != this.fRoot) {
                current = current.getParent();
            }
            if (result.contains(current)) continue;
            result.add(current);
        }
        return result;
    }

    public synchronized LinkedList getFileNodes() {
        LinkedList<SearchNode> result = new LinkedList<SearchNode>();
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            SearchNode current = element.getNode();
            while (current.getParent() != null && !(current instanceof FileNode)) {
                current = current.getParent();
            }
            if (result.contains(current)) continue;
            result.add(current);
        }
        return result;
    }

    public synchronized LinkedList getPackageNodes() {
        LinkedList<SearchNode> result = new LinkedList<SearchNode>();
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            SearchNode current = element.getNode();
            while (current.getParent() != null && current.getParent() instanceof ConstructNode) {
                current = current.getParent();
            }
            if (result.contains(current)) continue;
            result.add(current);
        }
        return result;
    }

    public synchronized LinkedList getMatchingNodes() {
        LinkedList<SearchNode> result = new LinkedList<SearchNode>();
        Iterator iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            MatchTag element = (MatchTag)iter.next();
            SearchNode current = element.getNode();
            if (result.contains(current)) continue;
            result.add(current);
        }
        return result;
    }
}

