/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.browsing.AdaCodeBrowser;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.browsing.AdaSearchResult;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class AdaQueryAllReferences
implements ISearchQuery {
    private AdaEntityReference fReference;
    private AdaSearchResult fSearchResults;
    private AdaEditor fEditor;
    private AdaCodeBrowser fBrowser;
    private int fScope;

    public AdaQueryAllReferences(AdaEntityReference reference, AdaEditor editor, int scope) throws IOException {
        this.fReference = reference;
        this.fSearchResults = new AdaSearchResult(this, "Ada references for \"" + reference.getName() + "\"", reference.getName());
        this.fEditor = editor;
        this.fBrowser = new AdaCodeBrowser();
        this.fScope = scope;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.fSearchResults.setResults(AdaCodeBrowser.getLocations((AdaEntityReference)this.fReference, (int)this.fScope, (IProgressMonitor)monitor), monitor);
        monitor.done();
        return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
    }

    public String getLabel() {
        return "Ada search for " + this.fReference.getName();
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fSearchResults;
    }

    public AdaEditor getEditor() {
        return this.fEditor;
    }
}

