/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.ui.browsing.AdaCallTree;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class AdaCallTreeHistoryDialog
extends SelectionDialog {
    private TableViewer fViewer;
    private Button fRemoveButton;
    private AdaCallTree fTree;
    private LinkedList fRemoved = new LinkedList();
    private LinkedList fDisplayed = new LinkedList();

    public AdaCallTreeHistoryDialog(Shell parentShell, AdaCallTree callTree) {
        super(parentShell);
        this.setTitle("Call Hierarchy History");
        this.fTree = callTree;
        this.fDisplayed = (LinkedList)callTree.getHistory().clone();
    }

    protected Control createDialogArea(Composite container) {
        Composite ancestor = (Composite)super.createDialogArea(container);
        this.createMessageArea(ancestor);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.fViewer = new TableViewer(parent, 68354);
        this.fViewer.setContentProvider((IContentProvider)new HistoryContentProvider());
        Table table = this.fViewer.getTable();
        this.fViewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        table.setLayoutData((Object)gd);
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText("Remove");
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AdaCallTreeHistoryDialog.this.fViewer.getSelection();
                Iterator iter = sel.iterator();
                while (iter.hasNext()) {
                    AdaConstruct construct = (AdaConstruct)iter.next();
                    AdaCallTreeHistoryDialog.this.fRemoved.add(construct);
                    AdaCallTreeHistoryDialog.this.fDisplayed.remove(construct);
                    AdaCallTreeHistoryDialog.this.fViewer.setInput((Object)AdaCallTreeHistoryDialog.this.fTree);
                }
            }
        });
        this.fRemoveButton.setLayoutData((Object)new GridData(1, 1, false, false));
        AdaCallTreeHistoryDialog.applyDialogFont((Control)ancestor);
        this.fViewer.setInput((Object)this.fTree);
        return table;
    }

    public LinkedList getRemoved() {
        return this.fRemoved;
    }

    private class HistoryContentProvider
    implements IStructuredContentProvider {
        private HistoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return AdaCallTreeHistoryDialog.this.fDisplayed.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryLabelProvider
    implements ILabelProvider {
        private HistoryLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof AdaConstruct) {
                return ((AdaConstruct)element).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

