/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.AdaConstructPassTroughFilter;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.core.browsing.AdaCodeBrowser;
import com.adacore.gnatbench.core.gpswrappers.Entity;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.browsing.AdaCallTree;
import com.adacore.gnatbench.ui.browsing.AdaCallTreeHistoryDialog;
import java.io.IOException;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class AdaCallTree
extends ViewPart
implements IAdaConstructFilterProvider {
    private TreeViewer fTreeViewer = null;
    private TableViewer fTableViewer = null;
    private static final int CALLING_MODE = 0;
    private static final int CALLED_BY_MODE = 1;
    private int fMode = 1;
    private static String MATCH_CALL_IMAGE = "match_call_image";
    private ContentProvider fContentProvider;
    private AdaCodeBrowser fCodeBrowser;
    private AdaConstruct fCurrentConstruct;
    private LinkedList fHistory = new LinkedList();

    public AdaCallTree() throws IOException {
        if (GNATbenchUIPlugin.getDefault().getImage(MATCH_CALL_IMAGE) == null) {
            GNATbenchUIPlugin.getDefault().addImage(MATCH_CALL_IMAGE, "/img/", "occ_match.gif");
        }
    }

    public void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        layout.type = 512;
        parent.setLayout((Layout)layout);
        this.fTreeViewer = new TreeViewer(parent, 770);
        this.fContentProvider = new ContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LabelProvider(), GNATbenchUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        IActionBars actionBar = this.getViewSite().getActionBars();
        actionBar.getToolBarManager().add((IAction)new ShowCallerHierarchy());
        actionBar.getToolBarManager().add((IAction)new ShowCalleeHierarchy());
        actionBar.getToolBarManager().add((IAction)new ShowHistory((Control)parent));
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof CallNode) {
                    CallNode node = (CallNode)selection.getFirstElement();
                    node.jumpInto();
                } else if (selection.getFirstElement() instanceof ErrorNode) {
                    ErrorNode node = (ErrorNode)selection.getFirstElement();
                    node.jumpInto();
                }
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdaCallTree.this.fTableViewer.getTable().removeAll();
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!(selection.getFirstElement() instanceof CallNode)) {
                    return;
                }
                CallNode node = (CallNode)((StructuredSelection)event.getSelection()).getFirstElement();
                if (node == null) {
                    return;
                }
                Iterator iter = node.fReferences.iterator();
                while (iter.hasNext()) {
                    AdaEntityReference ref = (AdaEntityReference)iter.next();
                    TableItem item = new TableItem(AdaCallTree.this.fTableViewer.getTable(), 0);
                    item.setImage(GNATbenchUIPlugin.getDefault().getImage(MATCH_CALL_IMAGE));
                    item.setText(1, String.valueOf(ref.getLocation().getGPSLine()));
                    AdaDocumentBuffer buffer = GNATbenchCorePlugin.getDefault().getDocumentBuffer(ref.getLocation());
                    int lastOffset = ref.getOffset() + ref.getName().length();
                    lastOffset = buffer.getFirstNonWhite(lastOffset);
                    if (buffer.getContent().charAt(lastOffset) == '(') {
                        try {
                            lastOffset = buffer.getCaracOffset(')', '(', lastOffset + 1, 1);
                        }
                        catch (BadLocationException e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                        catch (AdaDocumentBuffer.CaracNotFound e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                    }
                    if (buffer.getContent().charAt(lastOffset) == ')') {
                        ++lastOffset;
                    }
                    item.setText(2, buffer.getContent().substring(ref.getOffset(), lastOffset).replaceAll("[\n\r ]+", " "));
                    item.setData((Object)ref);
                }
            }
        });
        this.fTableViewer = new TableViewer(parent, 66310);
        this.createColumns();
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdaEntityReference ref = (AdaEntityReference)((StructuredSelection)event.getSelection()).getFirstElement();
                try {
                    GNATbenchUIPlugin.getDefault().openEditor(ref.getLocation());
                }
                catch (PartInitException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
                AdaCallTree.this.fTableViewer.getControl().forceFocus();
            }
        });
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.fTableViewer.getTable().setLayout((Layout)layout);
        this.fTableViewer.getTable().setHeaderVisible(true);
        String[] columnHeaders = new String[]{"", "Line", "Call"};
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(60), new ColumnWeightData(300)};
        int i = 0;
        while (i < columnHeaders.length) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(this.fTableViewer.getTable(), 0, i);
            tc.setResizable(columnLayouts[i].resizable);
            tc.setText(columnHeaders[i]);
            ++i;
        }
    }

    public void setFocus() {
    }

    public void setRootEntity(AdaEntityReference rootEntity) {
        Entity realEntity = null;
        AdaLocation entityLocation = null;
        realEntity = new Entity(rootEntity);
        entityLocation = realEntity.getBodyOrElseSpec();
        if (entityLocation == null) {
            return;
        }
        AdaConstruct construct = GNATbenchCorePlugin.getDefault().getDocumentBuffer(entityLocation).getAnalyzer().getConstructAt(entityLocation, (IAdaConstructFilterProvider)this);
        this.fHistory.add(construct);
        this.setRootConstruct(construct);
    }

    public void setRootConstruct(AdaConstruct construct) {
        if (this.fCodeBrowser == null) {
            this.fCodeBrowser = new AdaCodeBrowser();
        }
        AdaLocation entityLocation = construct.getLocation();
        if (!(construct == null || construct.getCategory() >= 3 && construct.getCategory() <= 10 && construct.getLocation().equals((Object)entityLocation))) {
            return;
        }
        this.fTreeViewer.setInput((Object)GNATbenchCorePlugin.getDefault().getDocumentBuffer(entityLocation).getEntity(entityLocation));
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandToLevel(2);
        this.fCurrentConstruct = construct;
    }

    public AdaConstructFilter getFilter() {
        return new AdaConstructPassTroughFilter(){

            public boolean simpleFilter(AdaConstruct construct) {
                int category = construct.getCategory();
                return category >= 1 && category <= 10;
            }
        };
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public LinkedList getHistory() {
        return this.fHistory;
    }

    private class CallNode {
        private LinkedList fChildren = null;
        private int fMode;
        private Entity fBrowsedEntity;
        private AdaConstruct fBrowsedConstruct;
        public LinkedList fReferences = new LinkedList();

        public CallNode(int mode, AdaEntityReference reference) {
            this.fMode = mode;
            if (mode == 0) {
                this.fBrowsedEntity = new Entity(reference);
            } else if (mode == 1) {
                this.fBrowsedEntity = this.getEnclosingEntity(reference);
            }
            this.fBrowsedConstruct = GNATbenchCorePlugin.getDefault().getDocumentBuffer(this.fBrowsedEntity.getSpecOrElseBody()).getAnalyzer().getConstructAt(this.fBrowsedEntity.getSpecOrElseBody(), (IAdaConstructFilterProvider)AdaCallTree.this);
            this.fReferences.add(reference);
        }

        private Entity getEnclosingEntity(AdaEntityReference reference) {
            AdaConstruct construct = GNATbenchCorePlugin.getDefault().getDocumentBuffer(reference.getLocation()).getAnalyzer().getConstructAt(reference.getLocation(), (IAdaConstructFilterProvider)AdaCallTree.this);
            return new Entity(reference.getLocation().getAdaFile().getProject(), construct);
        }

        public Object[] getChildren() {
            if (this.fChildren != null) {
                return this.fChildren.toArray();
            }
            if (this.fBrowsedConstruct.getCategory() == 1) {
                return new Object[0];
            }
            new Job(this, "Analyze children"){
                final /* synthetic */ CallNode this$1;
                {
                    this.this$1 = callNode;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    CallNode.access$1(this.this$1, CallNode.access$0(this.this$1, monitor));
                    new UIJob(this, "Update viewer"){
                        final /* synthetic */ 1 this$2;
                        {
                            super($anonymous0);
                            this.this$2 = var1_1;
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            AdaCallTree.access$0(CallNode.access$2(1.access$0(this.this$2))).refresh((Object)1.access$0(this.this$2));
                            return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
                        }
                    }.schedule();
                    return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
                }

                static /* synthetic */ CallNode access$0(1 var0) {
                    return var0.this$1;
                }
            }.schedule();
            return new Object[]{new String("...")};
        }

        private LinkedList internalGetChildren(IProgressMonitor monitor) {
            LinkedList<CallNode> result = new LinkedList<CallNode>();
            AbstractSequentialList references = null;
            AdaEntityReference baseReference = null;
            AdaLocation entityLocation = this.fBrowsedEntity.getBodyOrElseSpec();
            baseReference = GNATbenchCorePlugin.getDefault().getDocumentBuffer(entityLocation).getEntity(entityLocation);
            switch (this.fMode) {
                case 0: {
                    references = AdaCodeBrowser.getCalls((AdaEntityReference)baseReference, (boolean)false, (IProgressMonitor)monitor);
                    break;
                }
                case 1: {
                    references = AdaCodeBrowser.getCalls((AdaEntityReference)baseReference, (boolean)true, (IProgressMonitor)monitor);
                }
            }
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                LinkedList list = (LinkedList)iter.next();
                CallNode node = null;
                Iterator entityIter = list.iterator();
                while (entityIter.hasNext()) {
                    AdaEntityReference ref = (AdaEntityReference)entityIter.next();
                    if (node == null) {
                        node = new CallNode(this.fMode, ref);
                        continue;
                    }
                    node.fReferences.add(ref);
                }
                if (node == null) continue;
                result.add(node);
            }
            return result;
        }

        public boolean correspondTo(Entity entityReference) {
            if (entityReference.getBody() != null) {
                if (this.fBrowsedEntity.getBody() == null) {
                    return false;
                }
                return entityReference.getBody().equals((Object)this.fBrowsedEntity.getBody());
            }
            if (entityReference.getSpec() != null) {
                if (this.fBrowsedEntity.getSpec() == null) {
                    return false;
                }
                return entityReference.getSpec().equals((Object)this.fBrowsedEntity.getSpec());
            }
            return false;
        }

        public Entity getBrowsedEntity() {
            return this.fBrowsedEntity;
        }

        public AdaConstruct getBrowsedConstruct() {
            return this.fBrowsedConstruct;
        }

        public void freeEntities() {
            this.freeChildrenEntities();
        }

        private void freeChildrenEntities() {
            if (this.fChildren != null) {
                Iterator iter = this.fChildren.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof CallNode)) continue;
                    ((CallNode)element).freeEntities();
                }
                this.fChildren.clear();
            }
        }

        public String getText() {
            if (this.fBrowsedConstruct != null) {
                return this.fBrowsedConstruct.toString();
            }
            return this.fBrowsedEntity.getName();
        }

        public Image getImage() {
            if (this.fBrowsedConstruct != null) {
                return this.fBrowsedConstruct.getImage();
            }
            return null;
        }

        public void jumpInto() {
            try {
                if (this.fBrowsedConstruct != null) {
                    GNATbenchUIPlugin.getDefault().openEditor(this.fBrowsedConstruct.getLocation());
                } else {
                    GNATbenchUIPlugin.getDefault().openEditor(this.fBrowsedEntity.getBodyOrElseSpec());
                }
            }
            catch (PartInitException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }

        static /* synthetic */ LinkedList access$0(CallNode callNode, IProgressMonitor iProgressMonitor) {
            return callNode.internalGetChildren(iProgressMonitor);
        }

        static /* synthetic */ void access$1(CallNode callNode, LinkedList linkedList) {
            callNode.fChildren = linkedList;
        }

        static /* synthetic */ AdaCallTree access$2(CallNode callNode) {
            return callNode.AdaCallTree.this;
        }
    }

    private class ErrorNode {
        private AdaEntityReference fReference;

        public ErrorNode(AdaEntityReference ref) {
            this.fReference = ref;
        }

        public String getLabel() {
            return this.fReference.getLocation().toString();
        }

        public void jumpInto() {
            try {
                GNATbenchUIPlugin.getDefault().openEditor(this.fReference.getLocation());
            }
            catch (PartInitException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private CallNode fRootNode;
        private int fLastMode = 0;
        private Object fLastInput = null;

        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CallNode) {
                return ((CallNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof CallNode;
        }

        public Object[] getElements(Object inputElement) {
            if (this.fLastInput == inputElement && this.fLastMode == AdaCallTree.this.fMode) {
                return new Object[]{this.fRootNode};
            }
            this.fLastInput = inputElement;
            this.fLastMode = AdaCallTree.this.fMode;
            if (this.fRootNode != null) {
                this.fRootNode.freeEntities();
            }
            if (inputElement != null) {
                this.fRootNode = new CallNode(AdaCallTree.this.fMode, (AdaEntityReference)inputElement);
                return new Object[]{this.fRootNode};
            }
            this.fRootNode = null;
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void freeEntities() {
            if (this.fRootNode != null) {
                this.fRootNode.freeEntities();
            }
        }
    }

    private class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CallNode) {
                CallNode callNode = (CallNode)element;
                return callNode.getImage();
            }
            if (element instanceof ErrorNode) {
                return GNATbenchUIPlugin.getDefault().getImage("generic_error_message");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CallNode) {
                CallNode callNode = (CallNode)element;
                return callNode.getText();
            }
            if (element instanceof ErrorNode) {
                return ((ErrorNode)element).getLabel();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ShowCallerHierarchy
    extends Action {
        public ShowCallerHierarchy() {
            super("Show Caller Hierarchy", 8);
            this.setChecked(true);
        }

        public void run() {
            AdaCallTree.this.fMode = 1;
            AdaCallTree.this.fTreeViewer.refresh();
            AdaCallTree.this.fTreeViewer.expandToLevel(2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "ch_callers.gif");
        }

        public String getToolTipText() {
            return "Show Caller Hierarchy";
        }
    }

    private class ShowCalleeHierarchy
    extends Action {
        public ShowCalleeHierarchy() {
            super("Show Callee Hierarchy", 8);
        }

        public void run() {
            AdaCallTree.this.fMode = 0;
            AdaCallTree.this.fTreeViewer.refresh();
            AdaCallTree.this.fTreeViewer.expandToLevel(2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "ch_callees.gif");
        }

        public String getToolTipText() {
            return "Show Callee Hierarchy";
        }
    }

    private class CallHistory
    implements IMenuCreator {
        private CallHistory() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu m = new Menu(parent);
            Iterator iter = AdaCallTree.this.fHistory.iterator();
            while (iter.hasNext()) {
                AdaConstruct element = (AdaConstruct)iter.next();
                MenuItem mi = new MenuItem(m, 32);
                mi.setText(String.valueOf(element.getName()) + element.getProfile());
                mi.setImage(element.getImage());
                mi.addSelectionListener(new SelectionListener(this, element){
                    final /* synthetic */ CallHistory this$1;
                    private final /* synthetic */ AdaConstruct val$element;
                    {
                        this.this$1 = callHistory;
                        this.val$element = adaConstruct;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        CallHistory.access$1(this.this$1).setRootConstruct(this.val$element);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (AdaCallTree.this.fCurrentConstruct == element) {
                    mi.setSelection(true);
                    continue;
                }
                mi.setSelection(false);
            }
            return m;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        static /* synthetic */ AdaCallTree access$1(CallHistory callHistory) {
            return callHistory.AdaCallTree.this;
        }
    }

    private class ShowHistory
    extends Action {
        public ShowHistory(Control parent) {
            super("Show History List", 4);
            this.setMenuCreator(new CallHistory());
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "history_list.gif");
        }

        public String getToolTipText() {
            return "Show History List";
        }

        public void run() {
            AdaCallTreeHistoryDialog dlg = new AdaCallTreeHistoryDialog(AdaCallTree.this.getSite().getShell(), AdaCallTree.this);
            if (dlg.open() == 0) {
                LinkedList removed = dlg.getRemoved();
                Iterator iter = removed.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    AdaCallTree.this.fHistory.remove(element);
                }
            }
        }
    }
}

