/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.browsing;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.browsing.IAdaEntitySelectionProvider;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.browsing.AdaQueryAllReferences;
import java.io.IOException;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AdaActionReferences
extends TextEditorAction {
    private AdaEditor fEditor;
    private IAdaEntitySelectionProvider fSelectionProvider;
    private int fScope;

    public AdaActionReferences(ResourceBundle bundle, String prefix, AdaEditor editor, IAdaEntitySelectionProvider selectionProvider, int scope) {
        super(bundle, prefix, (ITextEditor)editor);
        this.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaReferencesInProject");
        this.setImageDescriptor(GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "search_ref_obj.gif"));
        this.fEditor = editor;
        this.fSelectionProvider = selectionProvider;
        this.fScope = scope;
    }

    public void run() {
        AdaEntityReference entity = this.fSelectionProvider.getEntitySelected();
        if (entity == null) {
            return;
        }
        NewSearchUI.activateSearchResultView();
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)new AdaQueryAllReferences(entity, this.fEditor, this.fScope));
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

