/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.VFS.File_Array;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class OpenFileFromProject
extends InputDialog {
    String[] fSources;
    List fFilesList;

    public OpenFileFromProject(Shell parentShell) {
        super(parentShell, "Open File From GPR Projects", "Open a source file from a GPR", "", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Control createDialogArea(Composite parent) {
        String[] prjSources;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fFilesList = new List(composite, 2564);
        this.fFilesList.setLayoutData((Object)new GridData(784));
        this.fFilesList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                List sourceList = (List)e.getSource();
                if (sourceList.getSelection().length > 0) {
                    OpenFileFromProject.this.getText().setText(sourceList.getSelection()[0]);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.getText().addTraverseListener((TraverseListener)new CompleteSourcesFile());
        int i = 0;
        while (i < 10) {
            this.fFilesList.add("");
            ++i;
        }
        try {
            prjSources = GNATbenchKernel.getDefault().getWorkspaceProject().getSourcesList(true);
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return composite;
        }
        int semDep = LibrarySemaphore.startGPSWork();
        try {
            File_Array stdFiles = GNATbenchKernel.getDefault().getProjectRegistry().Get_Predefined_Source_Files();
            this.fSources = new String[prjSources.length + stdFiles.Length()];
            int srcInd = 0;
            int i2 = 0;
            while (i2 < prjSources.length) {
                this.fSources[srcInd] = prjSources[i2];
                ++srcInd;
                ++i2;
            }
            i2 = stdFiles.First();
            while (i2 <= stdFiles.Last()) {
                this.fSources[srcInd] = stdFiles.Get_Element_At(i2).Full_Name(false).toString();
                ++srcInd;
                ++i2;
            }
            VFS_Package.Unchecked_Free((File_Array.Ref)((File_Array.Ref)stdFiles.NewObjectRef()));
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            LibrarySemaphore.stopGPSWork((int)semDep);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDep);
        int i3 = 0;
        while (i3 < this.fSources.length) {
            int index = this.fSources[i3].lastIndexOf(92);
            if (index == -1) {
                index = this.fSources[i3].lastIndexOf(47);
            }
            this.fSources[i3] = this.fSources[i3].substring(index + 1);
            ++i3;
        }
        return composite;
    }

    private class CompleteSourcesFile
    implements TraverseListener {
        private CompleteSourcesFile() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16 || e.detail == 8) {
                e.doit = false;
                OpenFileFromProject.this.fFilesList.removeAll();
                String uncompleteName = OpenFileFromProject.this.getText().getText();
                String completion = null;
                int i = 0;
                while (i < OpenFileFromProject.this.fSources.length) {
                    if (OpenFileFromProject.this.fSources[i].indexOf(uncompleteName) == 0) {
                        OpenFileFromProject.this.fFilesList.add(OpenFileFromProject.this.fSources[i]);
                        if (completion == null) {
                            completion = OpenFileFromProject.this.fSources[i];
                        } else {
                            int j = 0;
                            while (j < completion.length()) {
                                if (j >= OpenFileFromProject.this.fSources[i].length()) {
                                    completion = completion.substring(0, j);
                                    break;
                                }
                                if (completion.charAt(j) != OpenFileFromProject.this.fSources[i].charAt(j)) {
                                    completion = completion.substring(0, j);
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                OpenFileFromProject.this.getText().setText(completion);
                OpenFileFromProject.this.getText().setSelection(completion.length());
            }
        }
    }
}

