/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaEditorToolPreferencesProvider;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaAnnotationHover;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.codeassist.AdaCompletionProcessor;
import com.adacore.gnatbench.ui.codeassist.HTMLTextPresenter;
import com.adacore.gnatbench.ui.codingstyle.AdaMainAutoEditStrategy;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class AdaSourceViewerConfiguration
extends SourceViewerConfiguration {
    private AdaEditor fEditor;

    public AdaSourceViewerConfiguration(AdaEditor editor) {
        this.fEditor = editor;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__ada_gnatbench_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__ada_comment", "__ada_character", "__ada_string"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)GNATbenchUIPlugin.getDefault().getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new AdaMainAutoEditStrategy(this.fEditor.getDocumentBuffer())};
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AdaAnnotationHover();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sv) {
        if (GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST)) {
            ContentAssistant ca = new ContentAssistant();
            AdaCompletionProcessor pr = new AdaCompletionProcessor(this.fEditor);
            ca.setContentAssistProcessor((IContentAssistProcessor)pr, "__dftl_partition_content_type");
            ca.setInformationControlCreator(this.getInformationControlCreator(sv));
            ca.enableAutoActivation(GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST_AUTO_ACTIVATION));
            ca.setAutoActivationDelay(GNATbenchCorePlugin.getDefault().getPreferenceStore().getInt(AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST_DELAY));
            return ca;
        }
        return super.getContentAssistant(sv);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sv) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }
}

