/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;

public class AdaParenthesisHighlighting
implements KeyListener,
MouseListener {
    private ISourceViewer fViewer;
    private int fOffsetOpen = -1;
    private int fOffsetClose = -1;
    private Color fLastBackgroundOpen = null;
    private Color fLastBackgroundClose = null;
    private AdaDocumentBuffer fBuffer;

    public AdaParenthesisHighlighting(ISourceViewer viewer, AdaDocumentBuffer buffer) {
        this.fViewer = viewer;
        this.fBuffer = buffer;
        viewer.getTextWidget().addKeyListener((KeyListener)this);
        viewer.getTextWidget().addMouseListener((MouseListener)this);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        try {
            this.processHighlithing();
        }
        catch (BadLocationException badLocationException) {}
    }

    private void processHighlithing() throws BadLocationException {
        char carac;
        int offset = this.fViewer.getTextWidget().getCaretOffset();
        int newOffsetOpen = -1;
        int newOffsetClose = -1;
        if (offset >= this.fViewer.getDocument().getLength()) {
            offset = this.fViewer.getDocument().getLength() - 1;
        }
        if ((carac = this.fViewer.getDocument().getChar(offset)) != '(' && carac != ')' && offset > 0) {
            carac = this.fViewer.getDocument().getChar(--offset);
        }
        String contentType = "";
        try {
            IDocumentExtension3 extension = (IDocumentExtension3)this.fViewer.getDocument();
            contentType = extension.getContentType("__ada_gnatbench_partitioning", offset, false);
        }
        catch (BadLocationException badLocationException) {
            this.updateHighlithing(-1, -1);
            return;
        }
        catch (BadPartitioningException badPartitioningException) {
            this.updateHighlithing(-1, -1);
            return;
        }
        if (contentType != "__dftl_partition_content_type") {
            this.updateHighlithing(-1, -1);
            return;
        }
        try {
            if (carac == '(') {
                newOffsetOpen = offset;
                newOffsetClose = this.fBuffer.getCaracOffset(')', '(', offset + 1, 1);
            } else if (carac == ')') {
                newOffsetClose = offset;
                newOffsetOpen = this.fBuffer.getCaracOffset('(', ')', offset - 1, -1);
            }
        }
        catch (AdaDocumentBuffer.CaracNotFound caracNotFound) {
            newOffsetOpen = -1;
            newOffsetClose = -1;
            return;
        }
        this.updateHighlithing(newOffsetOpen, newOffsetClose);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        try {
            this.processHighlithing();
        }
        catch (BadLocationException badLocationException) {}
    }

    private void updateHighlithing(int newOffsetOpen, int newOffsetClose) {
        StyleRange styleRange;
        if (this.fOffsetOpen == newOffsetOpen && this.fOffsetClose == newOffsetClose) {
            return;
        }
        if (this.fOffsetOpen != -1 && (styleRange = this.fViewer.getTextWidget().getStyleRangeAtOffset(this.fOffsetOpen)) != null) {
            styleRange.background = this.fLastBackgroundOpen;
            this.fViewer.getTextWidget().setStyleRange(styleRange);
            this.fOffsetOpen = -1;
        }
        if (this.fOffsetClose != -1 && (styleRange = this.fViewer.getTextWidget().getStyleRangeAtOffset(this.fOffsetClose)) != null) {
            styleRange.background = this.fLastBackgroundClose;
            this.fViewer.getTextWidget().setStyleRange(styleRange);
            this.fOffsetClose = -1;
        }
        this.fOffsetOpen = newOffsetOpen;
        this.fOffsetClose = newOffsetClose;
        if (this.fOffsetOpen != -1 && this.fOffsetClose != -1) {
            StyleRange styleRangeOpen = this.fViewer.getTextWidget().getStyleRangeAtOffset(this.fOffsetOpen);
            StyleRange styleRangeClose = this.fViewer.getTextWidget().getStyleRangeAtOffset(this.fOffsetClose);
            if (styleRangeOpen == null) {
                styleRangeOpen = new StyleRange();
                styleRangeOpen.start = this.fOffsetOpen;
                styleRangeOpen.length = 1;
                this.fLastBackgroundOpen = null;
            } else {
                this.fLastBackgroundOpen = styleRangeOpen.background;
            }
            if (styleRangeClose == null) {
                styleRangeClose = new StyleRange();
                styleRangeClose.start = this.fOffsetClose;
                styleRangeClose.length = 1;
                this.fLastBackgroundClose = null;
            } else {
                this.fLastBackgroundClose = styleRangeClose.background;
            }
            styleRangeOpen.background = this.fViewer.getTextWidget().getDisplay().getSystemColor(26);
            styleRangeClose.background = this.fViewer.getTextWidget().getDisplay().getSystemColor(26);
            this.fViewer.getTextWidget().setStyleRange(styleRangeOpen);
            this.fViewer.getTextWidget().setStyleRange(styleRangeClose);
        }
    }
}

