/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AbstractAdaEditor;
import com.adacore.gnatbench.core.adaeditor.AdaEditorToolPreferencesProvider;
import com.adacore.gnatbench.core.adaeditor.AdaFileEditorInput;
import com.adacore.gnatbench.core.analyzer.AdaAnalyzer;
import com.adacore.gnatbench.core.analyzer.AdaAnalyzerJob;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.IAdaAnalyzerListener;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.core.browsing.IAdaEntitySelectionProvider;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaActionCompileFile;
import com.adacore.gnatbench.ui.adaeditor.AdaActionGenerateBody;
import com.adacore.gnatbench.ui.adaeditor.AdaActionToggleComment;
import com.adacore.gnatbench.ui.adaeditor.AdaBlocFolding;
import com.adacore.gnatbench.ui.adaeditor.AdaContentOutlinePage;
import com.adacore.gnatbench.ui.adaeditor.AdaEditorCodingStylePreferences;
import com.adacore.gnatbench.ui.adaeditor.AdaEditorMessages;
import com.adacore.gnatbench.ui.adaeditor.AdaParenthesisHighlighting;
import com.adacore.gnatbench.ui.adaeditor.AdaSourceViewerConfiguration;
import com.adacore.gnatbench.ui.browsing.AdaActionOpenBody;
import com.adacore.gnatbench.ui.browsing.AdaActionOpenCallHierarchy;
import com.adacore.gnatbench.ui.browsing.AdaActionOpenDeclaration;
import com.adacore.gnatbench.ui.browsing.AdaActionReferences;
import com.adacore.gnatbench.ui.browsing.AdaXrefsHyperlinks;
import com.adacore.gnatbench.ui.codingstyle.AdaActionIndent;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AdaEditor
extends AbstractAdaEditor
implements IPropertyChangeListener,
IDocumentListener,
IAdaEntitySelectionProvider {
    private AdaContentOutlinePage fOutlinePage;
    private AdaBlocFolding fBlocFolding;
    private FileEditorInput fFile;
    private SourceViewer fViewer = null;
    private AdaAnalyzerJob fAnalyzerJob;
    private HashMap fDocumentProviders = new HashMap();
    private boolean fBlocFoldingEnabled = GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorToolPreferencesProvider.PREF_TOOLS_BLOC_FOLDING);
    private UIJob fUpdateMarkersJob = null;
    static /* synthetic */ Class class$0;

    public void updateSemantics() {
        this.getDocumentBuffer().getAnalyzer().analyze();
    }

    public AdaAnalyzer getAnalyzer() {
        return this.getDocumentBuffer().getAnalyzer();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fBlocFolding = new AdaBlocFolding();
        this.fOutlinePage = new AdaContentOutlinePage(this);
        this.setSourceViewerConfiguration(new AdaSourceViewerConfiguration(this));
        this.setRulerContextMenuId("#AdaRulerContext");
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        Object viewer = this.fBlocFoldingEnabled ? new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles) : new SourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getOverviewRuler().addAnnotationType((Object)(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaLocationAnnotation"));
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        new AdaParenthesisHighlighting((ISourceViewer)viewer, this.getDocumentBuffer());
        AdaXrefsHyperlinks xRefsHyp = new AdaXrefsHyperlinks(this);
        viewer.getTextWidget().addMouseMoveListener((MouseMoveListener)xRefsHyp);
        viewer.getTextWidget().addMouseListener((MouseListener)xRefsHyp);
        this.fViewer = viewer;
        return viewer;
    }

    protected void adjustHighlightRange(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        }
    }

    public ISourceViewer getSourceViewerPublic() {
        return this.getSourceViewer();
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new AdaContentOutlinePage(this);
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public IMarker createMarker(String type) {
        try {
            return this.fFile.getFile().createMarker(type);
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return null;
        }
    }

    public void cleanAnnotations() {
        if (this.fViewer == null || this.fViewer.getAnnotationModel() == null) {
            return;
        }
        Iterator iter = this.fViewer.getAnnotationModel().getAnnotationIterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof SimpleMarkerAnnotation) || ((Annotation)element).getType().indexOf("com.adacore.gnatbench") == -1) continue;
            this.fViewer.getAnnotationModel().removeAnnotation((Annotation)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnotations() {
        AdaEditor adaEditor = this;
        synchronized (adaEditor) {
            if (this.fUpdateMarkersJob == null) {
                this.fUpdateMarkersJob = new UIJob("update annotations"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AdaEditor.this.realUpdateAnnotations();
                        AdaEditor adaEditor = AdaEditor.this;
                        synchronized (adaEditor) {
                            AdaEditor.this.fUpdateMarkersJob = null;
                        }
                        return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
                    }
                };
                this.fUpdateMarkersJob.schedule(1000L);
            }
        }
    }

    private void updateMarkerArray(IMarker[] markers) {
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            try {
                int charStart = marker.getAttribute("charStart", 0);
                int length = marker.getAttribute("charEnd", 0) - marker.getAttribute("charStart", 0);
                if (marker.isSubtypeOf("com.adacore.gnatbench.core.AdaErrorMarker")) {
                    String annotationSuffix = marker.getAttribute("severity", 0) == 1 ? ".AdaWarningAnnotation" : ".AdaErrorAnnotation";
                    this.fViewer.getAnnotationModel().addAnnotation((Annotation)new SimpleMarkerAnnotation(String.valueOf(GNATbenchUIPlugin.getId()) + annotationSuffix, marker), new Position(charStart, length));
                } else if (marker.isSubtypeOf("com.adacore.gnatbench.core.AdaLocationMarker")) {
                    this.fViewer.getAnnotationModel().addAnnotation((Annotation)new SimpleMarkerAnnotation(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaLocationAnnotation", marker), new Position(charStart, length));
                }
            }
            catch (CoreException coreException) {
                return;
            }
            ++i;
        }
    }

    private void realUpdateAnnotations() {
        if (this.fFile == null || this.fViewer == null || this.fViewer.getAnnotationModel() == null) {
            return;
        }
        this.updateMarkers();
        this.cleanAnnotations();
        if (!this.fFile.getFile().exists()) {
            return;
        }
        try {
            this.updateMarkerArray(this.fFile.getFile().findMarkers("com.adacore.gnatbench.core.AdaLocationMarker", true, 2));
            this.updateMarkerArray(this.fFile.getFile().findMarkers("com.adacore.gnatbench.core.AdaErrorMarker", true, 2));
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return;
        }
    }

    public AdaLocation getUpdatedLocation(IMarker marker) {
        if (this.fFile == null || this.fViewer == null || this.fViewer.getAnnotationModel() == null) {
            return AdaLocation.fromEclipse((AdaFile)this.getBaseLocation().getAdaFile(), (int)marker.getAttribute("lineNumber", 0), (int)marker.getAttribute("AdaLocationMarker.Column", 0));
        }
        Iterator iter = this.fViewer.getAnnotationModel().getAnnotationIterator();
        while (iter.hasNext()) {
            SimpleMarkerAnnotation annotation;
            Object element = iter.next();
            if (!(element instanceof SimpleMarkerAnnotation) || !(annotation = (SimpleMarkerAnnotation)element).getMarker().equals((Object)marker)) continue;
            Position position = this.fViewer.getAnnotationModel().getPosition((Annotation)annotation);
            int lineNumber = 0;
            int columnNumber = 0;
            try {
                lineNumber = this.getDocument().getLineOfOffset(position.offset);
                columnNumber = position.offset - this.getDocument().getLineOffset(lineNumber);
            }
            catch (BadLocationException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
            return AdaLocation.fromEclipse((AdaFile)this.getBaseLocation().getAdaFile(), (int)lineNumber, (int)columnNumber);
        }
        return AdaLocation.fromEclipse((AdaFile)this.getBaseLocation().getAdaFile(), (int)marker.getAttribute("lineNumber", 0), (int)marker.getAttribute("AdaLocationMarker.Column", 0));
    }

    public void addAnnotation(IMarker marker) {
        if (this.fViewer != null) {
            this.fViewer.getAnnotationModel().addAnnotation((Annotation)new SimpleMarkerAnnotation(marker), new Position(1, 10));
        }
    }

    public IFile getFile() {
        if (this.fFile != null) {
            return this.fFile.getFile();
        }
        return null;
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof FileEditorInput) {
            this.fFile = (FileEditorInput)input;
            this.updateAnnotations();
        }
        this.fBlocFolding.setDocument(this.getDocumentProvider().getDocument((Object)input));
        this.getDocument().addDocumentListener((IDocumentListener)this);
        this.fAnalyzerJob = new AdaAnalyzerJob("Compute semantics", this.getDocumentBuffer().getAnalyzer());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().indexOf("com.adacore") != -1) {
            ISourceViewer viewer = this.getSourceViewer();
            viewer.getTextWidget().redraw();
            viewer.setDocument(viewer.getDocument());
        }
    }

    public void refreshWidget() {
        this.getSourceViewer().getTextWidget().redraw();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fBlocFoldingEnabled) {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
            projectionSupport.install();
            viewer.doOperation(19);
            this.fBlocFolding.setAnnotationModel(viewer.getProjectionAnnotationModel());
            this.getDocumentBuffer().getAnalyzer().addAdaAnalyzerListener((IAdaAnalyzerListener)this.fBlocFolding);
            this.fBlocFolding.setRoots(this.getDocumentBuffer().getAnalyzer().getRoots((IAdaConstructFilterProvider)this.fBlocFolding));
        }
        this.cleanAnnotations();
        this.updateAnnotations();
    }

    public void documentChanged(DocumentEvent event) {
        this.fAnalyzerJob.notifyChange();
    }

    public void setDocumentProvider(IEditorInput input) {
        if (input instanceof AdaFileEditorInput) {
            IDocumentProvider provider = (IDocumentProvider)this.fDocumentProviders.get(input);
            if (provider == null) {
                provider = new TextFileDocumentProvider();
                this.fDocumentProviders.put(input, provider);
            }
            this.setDocumentProvider(provider);
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void focus(AdaLocation location) {
        int newOffset;
        try {
            newOffset = this.getDocument().getLineOffset(location.getEclipseLine()) + location.getEclipseColumn();
        }
        catch (BadLocationException badLocationException) {
            newOffset = 0;
        }
        this.selectAndReveal(newOffset, location.getLength());
        if (this.fOutlinePage != null) {
            this.fOutlinePage.focusEditor();
        }
    }

    private void updateMarkers() {
        IMarker[] markers;
        if (this.fFile == null || this.fViewer == null || this.fViewer.getAnnotationModel() == null) {
            return;
        }
        Iterator iter = this.fViewer.getAnnotationModel().getAnnotationIterator();
        while (iter.hasNext()) {
            SimpleMarkerAnnotation annotation;
            Object element = iter.next();
            if (!(element instanceof SimpleMarkerAnnotation) || !(annotation = (SimpleMarkerAnnotation)element).getType().equals(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaLocationAnnotation")) continue;
            Position position = this.fViewer.getAnnotationModel().getPosition((Annotation)annotation);
            IMarker marker = annotation.getMarker();
            if (!marker.exists()) continue;
            try {
                int lineNumber = this.getDocument().getLineOfOffset(position.offset);
                int columnNumber = position.offset - this.getDocument().getLineOffset(lineNumber);
                int offset = this.getDocumentBuffer().getOffset(lineNumber, columnNumber);
                int length = marker.getAttribute("charEnd", 0) - marker.getAttribute("charStart", 0) + 1;
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length - 1);
                marker.setAttribute("AdaLocationMarker.Column", columnNumber);
                marker.setAttribute("lineNumber", lineNumber);
            }
            catch (BadLocationException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
            catch (CoreException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
            }
        }
        try {
            markers = this.fFile.getFile().findMarkers("com.adacore.gnatbench.core.AdaLocationMarker", true, 2);
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return;
        }
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            try {
                String text;
                if (marker.isSubtypeOf("com.adacore.gnatbench.core.AdaLocationMarker") && (text = marker.getAttribute("AdaLocationMarker.Text", "")) != null && !text.equals("")) {
                    AdaLocation location = AdaLocation.fromEclipse((AdaFile)this.getBaseLocation().getAdaFile(), (int)marker.getAttribute("lineNumber", 0), (int)marker.getAttribute("AdaLocationMarker.Column", 0));
                    int length = marker.getAttribute("charEnd", 0) - marker.getAttribute("charStart", 0);
                    location = this.getDocumentBuffer().getClosestLocation(location, text);
                    int offset = this.getDocumentBuffer().getOffset(location);
                    marker.setAttribute("charStart", offset);
                    marker.setAttribute("charEnd", offset + length);
                    marker.setAttribute("AdaLocationMarker.Column", location.getEclipseColumn());
                    marker.setAttribute("lineNumber", location.getEclipseLine());
                }
            }
            catch (CoreException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
                return;
            }
            ++i;
        }
    }

    public AdaLocation getCurrentLocation() {
        try {
            TextSelection selection = (TextSelection)this.fViewer.getSelection();
            int offsetBegin = selection.getOffset();
            int column = offsetBegin - this.getDocument().getLineOffset(selection.getStartLine());
            AdaLocation location = AdaLocation.fromEclipse((AdaFile)this.getBaseLocation().getAdaFile(), (int)selection.getStartLine(), (int)column);
            location.setLength(selection.getLength());
            return location;
        }
        catch (BadLocationException badLocationException) {
            return this.getBaseLocation();
        }
    }

    public AdaEntityReference getEntitySelected() {
        TextSelection selection = (TextSelection)this.fViewer.getSelection();
        return this.getDocumentBuffer().getEntity(selection.getOffset());
    }

    public void doSave(IProgressMonitor monitor) {
        if (GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorCodingStylePreferences.PREF_CODING_STYLE_REMOVE_SPACES)) {
            this.removeTrailingSpaces();
        }
        super.doSave(monitor);
    }

    public void doSaveAs(IProgressMonitor monitor) {
        if (GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorCodingStylePreferences.PREF_CODING_STYLE_REMOVE_SPACES)) {
            this.removeTrailingSpaces();
        }
        super.doSaveAs();
    }

    private void removeTrailingSpaces() {
        FindReplaceDocumentAdapter findReplace = new FindReplaceDocumentAdapter(this.getDocument());
        try {
            IRegion region = null;
            int index = 0;
            while (index < this.getDocument().getLength() && (region = findReplace.find(index, "( )+$", true, false, false, true)) != null) {
                findReplace.replace("", false);
                index = region.getOffset();
            }
        }
        catch (BadLocationException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    public void dispose() {
        this.updateMarkers();
        super.dispose();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        MenuManager referencesManager = new MenuManager("References");
        this.addAction((IMenuManager)referencesManager, "ReferencesInProject");
        this.addAction((IMenuManager)referencesManager, "ReferencesInWorkspace");
        menu.appendToGroup("group.save", (IContributionItem)new Separator());
        this.addAction(menu, "group.save", "OpenDeclaration");
        this.addAction(menu, "group.save", "OpenBody");
        this.addAction(menu, "group.save", "OpenCallHierarchy");
        this.addAction(menu, "group.edit", "ToggleComment");
        this.addAction(menu, "group.edit", "CorrectIndent");
        this.addAction(menu, "group.edit", "GenerateBody");
        this.addAction(menu, "group.edit", "EditInGPS");
        menu.appendToGroup("group.edit", (IContributionItem)new Separator());
        menu.appendToGroup("group.edit", (IContributionItem)referencesManager);
        menu.appendToGroup("additions", (IContributionItem)new Separator());
        menu.appendToGroup("additions", this.getAction("CompileFile"));
    }

    protected void createActions() {
        super.createActions();
        TextEditorAction action = new AdaActionOpenCallHierarchy(AdaEditorMessages.getResourceBundle(), "AdaOpenCallHierarchy.", this);
        action.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaOpenCallHierarchy");
        this.setAction("OpenCallHierarchy", (IAction)action);
        action = new AdaActionIndent(AdaEditorMessages.getResourceBundle(), "AdaIndent.", this);
        action.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaCorrectIndent");
        this.setAction("CorrectIndent", (IAction)action);
        action = new AdaActionToggleComment(AdaEditorMessages.getResourceBundle(), "AdaToggleComment.", this);
        action.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaToggleComment");
        this.setAction("ToggleComment", (IAction)action);
        action = new AdaActionOpenDeclaration(AdaEditorMessages.getResourceBundle(), "AdaOpenDeclaration.", this);
        action.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaOpenDeclaration");
        this.setAction("OpenDeclaration", (IAction)action);
        action = new AdaActionOpenBody(AdaEditorMessages.getResourceBundle(), "AdaOpenBody.", this);
        action.setActionDefinitionId(String.valueOf(GNATbenchUIPlugin.getId()) + ".AdaOpenBody");
        this.setAction("OpenBody", (IAction)action);
        action = new AdaActionReferences(AdaEditorMessages.getResourceBundle(), "AdaReferencesInProject.", this, this, 1);
        this.setAction("ReferencesInProject", (IAction)action);
        action = new AdaActionReferences(AdaEditorMessages.getResourceBundle(), "AdaReferencesInWorkspace.", this, this, 2);
        this.setAction("ReferencesInWorkspace", (IAction)action);
        action = new AdaActionCompileFile(AdaEditorMessages.getResourceBundle(), "AdaCompileFile.", this);
        this.setAction("CompileFile", (IAction)action);
        action = new AdaActionGenerateBody(AdaEditorMessages.getResourceBundle(), "AdaGenerateBody.", this);
        this.setAction("GenerateBody", (IAction)action);
        action = new ContentAssistAction(AdaEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{String.valueOf(GNATbenchCorePlugin.getId()) + ".adaEditorContext"});
    }
}

