/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaAnalyzer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaConstructCutFilter;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.AdaConstructPassTroughFilter;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.IAdaAnalyzerListener;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.core.browsing.IAdaEntitySelectionProvider;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaContentOutlinePage;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.adaeditor.AdaEditorMessages;
import com.adacore.gnatbench.ui.browsing.AdaActionReferences;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AdaContentOutlinePage
extends ContentOutlinePage
implements KeyListener,
MouseListener,
IAdaEntitySelectionProvider {
    private AdaEditor fEditor;
    private static final String ICON_WITH_LIST = "icon_with_list";
    private boolean fHidePrivate = false;
    private boolean fDoSort = false;
    private boolean fDoGroup = false;
    private boolean fHideFields = false;
    private boolean fLinkedWithEditor = false;
    private ContentProvider fContentProvider;
    private TreeViewer fViewer;
    private boolean fFocusOutline = true;

    public AdaContentOutlinePage(AdaEditor editor) {
        this.fEditor = editor;
        if (GNATbenchUIPlugin.getDefault().getImage(ICON_WITH_LIST) == null) {
            GNATbenchUIPlugin.getDefault().addImage(ICON_WITH_LIST, "/img/", "impc_obj.gif");
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.fContentProvider = new ContentProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LabelProvider(), GNATbenchUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        FollowSelection follower = new FollowSelection();
        viewer.addSelectionChangedListener((ISelectionChangedListener)follower);
        viewer.setInput((Object)this.fEditor.getAnalyzer());
        this.fViewer = viewer;
        this.fEditor.getSourceViewerPublic().getTextWidget().addKeyListener((KeyListener)this);
        this.fEditor.getSourceViewerPublic().getTextWidget().addMouseListener((MouseListener)this);
        MenuManager baseManager = new MenuManager();
        final MenuManager referencesManager = new MenuManager("References");
        Menu menu = baseManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        baseManager.add((IContributionItem)referencesManager);
        new UIJob("Defining bindings"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IViewPart view = AdaContentOutlinePage.this.getSite().getPage().findView("org.eclipse.ui.views.ContentOutline");
                if (view != null && view.getSite() != null) {
                    AdaActionReferences action = new AdaActionReferences(AdaEditorMessages.getResourceBundle(), "AdaReferencesInProject.", AdaContentOutlinePage.this.fEditor, AdaContentOutlinePage.this, 1);
                    referencesManager.add((IAction)action);
                    action = new AdaActionReferences(AdaEditorMessages.getResourceBundle(), "AdaReferencesInWorkspace.", AdaContentOutlinePage.this.fEditor, AdaContentOutlinePage.this, 2);
                    referencesManager.add((IAction)action);
                    view.getSite().getKeyBindingService().registerAction((IAction)action);
                    view.getSite().getKeyBindingService().setScopes(new String[]{String.valueOf(GNATbenchCorePlugin.getId()) + ".adaEditorContext"});
                }
                return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
            }
        }.schedule();
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        actionBars.getToolBarManager().add((IAction)new SortAction());
        actionBars.getToolBarManager().add((IAction)new GroupAction());
        actionBars.getToolBarManager().add((IAction)new HideFieldsAction());
        actionBars.getToolBarManager().add((IAction)new HidePrivateAction());
        actionBars.getToolBarManager().add((IAction)new LinkEditorAction());
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.focusEditor();
    }

    public void focusEditor() {
        if (this.fLinkedWithEditor) {
            boolean doGroup = this.fDoGroup;
            this.fDoGroup = false;
            AdaConstruct element = this.fEditor.getAnalyzer().getConstructAt(this.fEditor.getCurrentLocation(), new IAdaConstructFilterProvider(){

                public AdaConstructFilter getFilter() {
                    return AdaContentOutlinePage.this.getFilter(true);
                }
            });
            this.fDoGroup = doGroup;
            if (element == null) {
                return;
            }
            if (this.fDoGroup) {
                element = element.getMainConstruct();
            }
            if (element != null) {
                this.fFocusOutline = false;
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                this.fFocusOutline = true;
                this.fViewer.expandToLevel((Object)element, 0);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.focusEditor();
    }

    public AdaConstructFilter getFilter(boolean includeWith) {
        class BaseAndWithFilter
        extends AdaConstructPassTroughFilter {
            final /* synthetic */ AdaContentOutlinePage this$0;

            BaseAndWithFilter(AdaContentOutlinePage adaContentOutlinePage) {
                this.this$0 = adaContentOutlinePage;
            }

            public boolean simpleFilter(AdaConstruct construct) {
                int category = construct.getCategory();
                return category >= 1 && category <= 17 || category == 19 || category == 22;
            }
        }
        class BaseFilter
        extends AdaConstructPassTroughFilter {
            final /* synthetic */ AdaContentOutlinePage this$0;

            public BaseFilter(AdaContentOutlinePage adaContentOutlinePage) {
                this.this$0 = adaContentOutlinePage;
            }

            public boolean simpleFilter(AdaConstruct construct) {
                int category = construct.getCategory();
                return category >= 1 && category <= 17 || category == 19;
            }
        }
        Object filter = includeWith ? new BaseAndWithFilter(this) : new BaseFilter(this);
        if (this.fHidePrivate) {
            class PrivateFilter
            extends AdaConstructCutFilter {
                final /* synthetic */ AdaContentOutlinePage this$0;

                public PrivateFilter(AdaContentOutlinePage adaContentOutlinePage, AdaConstructFilter filter) {
                    super(filter);
                    this.this$0 = adaContentOutlinePage;
                }

                public boolean simpleFilter(AdaConstruct construct) {
                    return construct.getVisibility() == 2;
                }
            }
            filter = new PrivateFilter(this, (AdaConstructFilter)filter);
        }
        if (this.fHideFields) {
            class FieldsFilter
            extends AdaConstructCutFilter {
                final /* synthetic */ AdaContentOutlinePage this$0;

                public FieldsFilter(AdaContentOutlinePage adaContentOutlinePage, AdaConstructFilter filter) {
                    super(filter);
                    this.this$0 = adaContentOutlinePage;
                }

                public boolean simpleFilter(AdaConstruct construct) {
                    int category = construct.getCategory();
                    return category != 19 && category != 16 && category != 17;
                }
            }
            filter = new FieldsFilter(this, (AdaConstructFilter)filter);
        }
        return filter;
    }

    public AdaEntityReference getEntitySelected() {
        StructuredSelection selection = (StructuredSelection)this.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof AdaConstruct) {
            AdaConstruct construct = (AdaConstruct)obj;
            return new AdaEntityReference(this.fEditor.getDocumentBuffer(), construct);
        }
        return null;
    }

    private class ConstructComparator
    implements Comparator {
        private ConstructComparator() {
        }

        public int getCategoryOrder(int cat) {
            if (cat == 1) {
                return 1;
            }
            if (cat >= 3 && cat <= 10) {
                return 4;
            }
            if (cat >= 11 && cat <= 15) {
                return 2;
            }
            if (cat == 16) {
                return 3;
            }
            return 0;
        }

        public int compare(Object arg0, Object arg1) {
            int cat1;
            AdaConstruct c0 = (AdaConstruct)arg0;
            AdaConstruct c1 = (AdaConstruct)arg1;
            int cat0 = this.getCategoryOrder(c0.getCategory());
            if (cat0 == (cat1 = this.getCategoryOrder(c1.getCategory())) && c0.getVisibility() == c1.getVisibility()) {
                return ((AdaConstruct)arg0).getName().compareTo(((AdaConstruct)arg1).getName());
            }
            if (cat0 == cat1) {
                if (c0.getVisibility() > c1.getVisibility()) {
                    return -1;
                }
                return 1;
            }
            if (cat0 > cat1) {
                return 1;
            }
            return -1;
        }
    }

    private class WithDeclarations
    implements IAdaAnalyzerListener {
        private LinkedList fWith = new LinkedList();

        private WithDeclarations() {
        }

        public void add(AdaConstruct construct) {
            this.fWith.add(construct);
        }

        public String toString() {
            return "with declarations";
        }

        public Object[] getChildren() {
            return this.fWith.toArray();
        }

        public void elementAdded(AdaConstruct element) {
            this.fWith.add(element);
            if (this.fWith.size() == 1) {
                AdaContentOutlinePage.this.fContentProvider.reload();
            } else {
                AdaContentOutlinePage.this.fViewer.refresh((Object)this, false);
            }
        }

        public void elementRemoved(AdaConstruct element) {
            this.fWith.remove(element);
            if (this.fWith.size() == 0) {
                AdaContentOutlinePage.this.fContentProvider.reload();
            } else {
                AdaContentOutlinePage.this.fViewer.refresh((Object)this, false);
            }
        }

        public void elementModified(AdaConstruct element) {
        }

        public void setRoots(AdaConstruct[] roots) {
            this.fWith.clear();
            int i = 0;
            while (i < roots.length) {
                this.fWith.add(roots[i]);
                ++i;
            }
        }

        public boolean hasChildren() {
            return this.fWith.size() > 0;
        }

        public AdaConstructFilter getFilter() {
            return new AdaConstructCutFilter(this){
                final /* synthetic */ WithDeclarations this$1;
                {
                    this.this$1 = withDeclarations;
                }

                public boolean simpleFilter(AdaConstruct construct) {
                    return construct.getCategory() == 22;
                }
            };
        }
    }

    private class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof AdaConstruct) {
                AdaConstruct adaElement = (AdaConstruct)element;
                return adaElement.getImage();
            }
            if (element instanceof WithDeclarations) {
                image = GNATbenchUIPlugin.getDefault().getImage(AdaContentOutlinePage.ICON_WITH_LIST);
            }
            return image;
        }

        public String getText(Object element) {
            if (AdaContentOutlinePage.this.fDoGroup && element instanceof AdaConstruct) {
                if (((AdaConstruct)element).getNbParts() > 0) {
                    return "* " + element.toString();
                }
                return element.toString();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ContentProvider
    implements ITreeContentProvider,
    IAdaAnalyzerListener {
        private AdaConstruct[] fRoots = null;
        private AdaAnalyzer fAnalyzer;
        private WithDeclarations fWith;

        private ContentProvider() {
            this.fWith = new WithDeclarations();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AdaConstruct) {
                Object[] constructs = AdaContentOutlinePage.this.fDoGroup ? ((AdaConstruct)parentElement).getAllMainChildren((IAdaConstructFilterProvider)this) : ((AdaConstruct)parentElement).getChildren((IAdaConstructFilterProvider)this);
                if (AdaContentOutlinePage.this.fDoSort) {
                    Arrays.sort(constructs, new ConstructComparator());
                }
                return constructs;
            }
            if (parentElement instanceof WithDeclarations) {
                if (!AdaContentOutlinePage.this.fDoSort) {
                    return ((WithDeclarations)parentElement).getChildren();
                }
                Object[] constructs = ((WithDeclarations)parentElement).getChildren();
                Arrays.sort(constructs, new ConstructComparator());
                return constructs;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof AdaConstruct) {
                AdaConstruct construct = (AdaConstruct)element;
                if (construct.getCategory() == 22) {
                    return this.fWith;
                }
                if (!AdaContentOutlinePage.this.fDoGroup) {
                    return ((AdaConstruct)element).getParent((IAdaConstructFilterProvider)this);
                }
                return ((AdaConstruct)element).getMainParent((IAdaConstructFilterProvider)this);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AdaConstruct) {
                if (AdaContentOutlinePage.this.fDoGroup) {
                    return ((AdaConstruct)element).getAllMainChildren((IAdaConstructFilterProvider)this).length > 0;
                }
                return ((AdaConstruct)element).hasChildren((IAdaConstructFilterProvider)this);
            }
            if (element instanceof WithDeclarations) {
                return ((WithDeclarations)element).hasChildren();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (this.fRoots != null) {
                if (this.fWith.hasChildren()) {
                    Object[] elements = new Object[this.fRoots.length + 1];
                    elements[0] = this.fWith;
                    int i = 0;
                    while (i < this.fRoots.length) {
                        elements[i + 1] = this.fRoots[i];
                        ++i;
                    }
                    return elements;
                }
                return this.fRoots;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && oldInput instanceof AdaAnalyzer) {
                ((AdaAnalyzer)oldInput).removeAdaAnalyzerListener((IAdaAnalyzerListener)this);
                ((AdaAnalyzer)oldInput).removeAdaAnalyzerListener((IAdaAnalyzerListener)this.fWith);
                this.fRoots = null;
                this.fAnalyzer = null;
            }
            if (newInput != null && newInput instanceof AdaAnalyzer) {
                ((AdaAnalyzer)newInput).addAdaAnalyzerListener((IAdaAnalyzerListener)this);
                ((AdaAnalyzer)newInput).addAdaAnalyzerListener((IAdaAnalyzerListener)this.fWith);
                this.fRoots = ((AdaAnalyzer)newInput).getRoots((IAdaConstructFilterProvider)this);
                this.fWith.setRoots(((AdaAnalyzer)newInput).getRoots((IAdaConstructFilterProvider)this.fWith));
                this.fAnalyzer = (AdaAnalyzer)newInput;
            }
        }

        public void elementAdded(AdaConstruct element) {
            AdaContentOutlinePage.this.fViewer.getControl().setRedraw(false);
            if (element.getCategory() == 22) {
                this.fWith.add(element);
                AdaContentOutlinePage.this.fViewer.refresh((Object)this.fWith, false);
            } else if (element.getParent((IAdaConstructFilterProvider)this) == null) {
                this.fRoots = this.fAnalyzer.getRoots((IAdaConstructFilterProvider)this);
                AdaContentOutlinePage.this.fViewer.refresh();
            } else {
                AdaContentOutlinePage.this.fViewer.refresh((Object)element.getParent((IAdaConstructFilterProvider)this), false);
            }
            AdaContentOutlinePage.this.fViewer.getControl().setRedraw(true);
        }

        public void elementRemoved(AdaConstruct element) {
            AdaContentOutlinePage.this.fViewer.getControl().setRedraw(false);
            if (element.getParent((IAdaConstructFilterProvider)this) == null) {
                this.fRoots = this.fAnalyzer.getRoots((IAdaConstructFilterProvider)this);
                AdaContentOutlinePage.this.fViewer.refresh();
            } else {
                AdaContentOutlinePage.this.fViewer.refresh((Object)element.getParent((IAdaConstructFilterProvider)this), false);
            }
            AdaContentOutlinePage.this.fViewer.getControl().setRedraw(true);
        }

        public void elementModified(AdaConstruct element) {
            if (element.getParent((IAdaConstructFilterProvider)this) != null) {
                AdaContentOutlinePage.this.fViewer.refresh((Object)element.getParent((IAdaConstructFilterProvider)this));
            } else {
                AdaContentOutlinePage.this.fViewer.refresh();
            }
        }

        public void reload() {
            this.inputChanged((Viewer)AdaContentOutlinePage.this.fViewer, this.fAnalyzer, this.fAnalyzer);
            AdaContentOutlinePage.this.fViewer.refresh();
        }

        public AdaConstructFilter getFilter() {
            return AdaContentOutlinePage.this.getFilter(false);
        }
    }

    private class HideFieldsAction
    extends Action {
        public HideFieldsAction() {
            super("Hide Fields and Variables", 2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "fields_co.gif");
        }

        public void run() {
            super.run();
            AdaContentOutlinePage.this.fHideFields = this.isChecked();
            AdaContentOutlinePage.this.fContentProvider.reload();
        }

        public String getToolTipText() {
            return "Hide Fields and Variables";
        }
    }

    private class HidePrivateAction
    extends Action {
        public HidePrivateAction() {
            super("Hide Non-Public Entities", 2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "methpub_obj.gif");
        }

        public void run() {
            super.run();
            AdaContentOutlinePage.this.fHidePrivate = this.isChecked();
            AdaContentOutlinePage.this.fContentProvider.reload();
        }

        public String getToolTipText() {
            return "Hide Non-Public Entities";
        }
    }

    private class SortAction
    extends Action {
        public SortAction() {
            super("Sort", 2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "alphab_sort_co.gif");
        }

        public void run() {
            super.run();
            AdaContentOutlinePage.this.fDoSort = this.isChecked();
            AdaContentOutlinePage.this.fContentProvider.reload();
        }

        public String getToolTipText() {
            return "Sort";
        }
    }

    private class LinkEditorAction
    extends Action {
        public LinkEditorAction() {
            super("Link With Editor", 2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "synced.gif");
        }

        public void run() {
            AdaContentOutlinePage.this.fLinkedWithEditor = this.isChecked();
            AdaContentOutlinePage.this.focusEditor();
        }

        public String getToolTipText() {
            return "Link With Editor";
        }
    }

    private class GroupAction
    extends Action {
        public GroupAction() {
            super("Group Partial Entities", 2);
        }

        public ImageDescriptor getImageDescriptor() {
            return GNATbenchUIPlugin.getDefault().getImageDescriptor("/img/", "group_action.gif");
        }

        public void run() {
            AdaContentOutlinePage.this.fDoGroup = this.isChecked();
            AdaContentOutlinePage.this.fContentProvider.reload();
        }

        public String getToolTipText() {
            return "Group Partial Entities";
        }
    }

    private class FollowSelection
    implements ISelectionChangedListener {
        private FollowSelection() {
        }

        public void focus() {
            StructuredSelection selection = (StructuredSelection)AdaContentOutlinePage.this.fViewer.getSelection();
            Object selected = selection.getFirstElement();
            if (selected instanceof AdaConstruct) {
                AdaConstruct element = (AdaConstruct)selected;
                AdaLocation location = AdaLocation.fromGPS((AdaFile)element.getLocation().getAdaFile(), (int)1, (int)1);
                AdaEditor editor = (AdaEditor)GNATbenchCorePlugin.getDefault().getEditor(location);
                int offsetFocus = element.getOffsetEntity();
                if (AdaContentOutlinePage.this.fDoGroup) {
                    int offset = editor.getSourceViewerPublic().getSelectedRange().x;
                    AdaConstruct currentElement = null;
                    if (offset == offsetFocus) {
                        currentElement = element;
                    } else if (element.getPart1() != null && element.getPart1().getOffsetEntity() == offset) {
                        currentElement = element.getPart1();
                    } else if (element.getPart2() != null && element.getPart2().getOffsetEntity() == offset) {
                        currentElement = element.getPart2();
                    }
                    if (currentElement != null) {
                        AdaConstructFilter filter = AdaContentOutlinePage.this.getFilter(false);
                        element = currentElement.getNextPart();
                        while (!filter.simpleFilter(element)) {
                            element = element.getNextPart();
                        }
                    }
                }
                editor.selectAndReveal(element.getOffsetEntity(), element.getName().length());
            }
            AdaContentOutlinePage.this.fViewer.getControl().forceFocus();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (AdaContentOutlinePage.this.fFocusOutline) {
                this.focus();
            }
        }
    }
}

