/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaConstructCutFilter;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.IAdaAnalyzerListener;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import java.util.HashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class AdaBlocFolding
implements IAdaAnalyzerListener {
    private HashMap fOldAnnotations = new HashMap();
    private ProjectionAnnotationModel fAnnotationModel = null;
    private IDocument fDocument;

    public void setAnnotationModel(ProjectionAnnotationModel model) {
        this.fAnnotationModel = model;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public ProjectionAnnotationModel getAnnotationModel() {
        return this.fAnnotationModel;
    }

    public void setRoots(AdaConstruct[] elements) {
        if (this.fAnnotationModel == null) {
            return;
        }
        this.fAnnotationModel.removeAllAnnotations();
        int i = 0;
        while (i < elements.length) {
            this.addElement(elements[i]);
            ++i;
        }
    }

    public boolean filter(AdaConstruct element) {
        int category = element.getCategory();
        return category >= 1 && category <= 15 || category >= 25;
    }

    public void elementAdded(AdaConstruct element) {
        if (this.fAnnotationModel == null) {
            return;
        }
        this.addElement(element);
    }

    public void elementRemoved(AdaConstruct element) {
        if (this.fAnnotationModel == null) {
            return;
        }
        this.removeElement(element);
    }

    public void elementModified(AdaConstruct element) {
        if (this.fAnnotationModel == null) {
            return;
        }
        this.modifyElement(element);
    }

    private void removeAnnotation(AdaConstruct element) {
        try {
            Annotation oldAnnotation = (Annotation)this.fOldAnnotations.get(element);
            if (oldAnnotation == null) {
                return;
            }
            this.fAnnotationModel.removeAnnotation(oldAnnotation);
            this.fOldAnnotations.remove(element);
        }
        catch (Exception e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    private void addAnnotation(AdaConstruct element) {
        Position position;
        try {
            position = this.getPosition(element);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        ProjectionAnnotation annotation = new ProjectionAnnotation();
        this.fAnnotationModel.addAnnotation((Annotation)annotation, position);
        this.fOldAnnotations.put(element, annotation);
    }

    private void removeElement(AdaConstruct element) {
        if (!this.filter(element)) {
            return;
        }
        AdaConstruct[] children = element.getChildren((IAdaConstructFilterProvider)this);
        int i = 0;
        while (i < children.length) {
            this.removeElement(children[i]);
            ++i;
        }
        this.removeAnnotation(element);
    }

    private void addElement(AdaConstruct element) {
        if (!this.filter(element)) {
            return;
        }
        AdaConstruct[] children = element.getChildren((IAdaConstructFilterProvider)this);
        int i = 0;
        while (i < children.length) {
            this.addElement(children[i]);
            ++i;
        }
        if (element.getLineBegin() == element.getLineEnd()) {
            return;
        }
        this.addAnnotation(element);
    }

    private void modifyElement(AdaConstruct element) {
        Position position;
        if (!this.filter(element)) {
            return;
        }
        AdaConstruct[] children = element.getChildren((IAdaConstructFilterProvider)this);
        int i = 0;
        while (i < children.length) {
            this.modifyElement(children[i]);
            ++i;
        }
        try {
            position = this.getPosition(element);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Annotation oldAnnotation = (Annotation)this.fOldAnnotations.get(element);
        Position oldPosition = this.fAnnotationModel.getPosition(oldAnnotation);
        if (oldPosition != null) {
            if (element.getLineBegin() == element.getLineEnd()) {
                this.removeAnnotation(element);
            } else if (oldPosition.length != position.length || oldPosition.offset != position.offset) {
                try {
                    this.fAnnotationModel.modifyAnnotationPosition((Annotation)this.fOldAnnotations.get(element), position);
                }
                catch (Exception e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
            }
        } else if (oldAnnotation == null && element.getLineBegin() != element.getLineEnd()) {
            this.addAnnotation(element);
        }
    }

    private Position getPosition(AdaConstruct element) throws BadLocationException {
        int offsetBegin = element.getOffsetBegin();
        int lineEnd = element.getLineEnd();
        int offsetEnd = 0;
        offsetEnd = this.fDocument.getLineOffset(lineEnd) + this.fDocument.getLineLength(lineEnd) - 1;
        return new Position(offsetBegin, offsetEnd - offsetBegin + 1);
    }

    public AdaConstructFilter getFilter() {
        return new AdaConstructCutFilter(){

            public boolean simpleFilter(AdaConstruct construct) {
                return AdaBlocFolding.this.filter(construct);
            }
        };
    }
}

