/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AdaActionToggleComment
extends TextEditorAction {
    private AdaEditor fEditor;

    public AdaActionToggleComment(ResourceBundle bundle, String prefix, AdaEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.fEditor = editor;
    }

    public void run() {
        String text = this.fEditor.getDocumentBuffer().getContent();
        IDocument document = this.fEditor.getDocumentBuffer().getDocument();
        TextSelection selection = (TextSelection)((TextViewer)this.fEditor.getSourceViewerPublic()).getSelection();
        int selectionOffsetBegin = selection.getOffset();
        int selectionOffsetEnd = selection.getOffset() + selection.getLength();
        int newSelectionOffsetBegin = selectionOffsetBegin;
        int newSelectionOffsetEnd = selectionOffsetEnd;
        try {
            String result;
            int offsetLineBegin = document.getLineOffset(selection.getStartLine());
            int offsetLineEnd = text.indexOf("\n", selection.getOffset() + selection.getLength()) - 1;
            if (offsetLineEnd < 0) {
                offsetLineEnd = text.length();
            }
            if ((result = text.substring(offsetLineBegin, offsetLineEnd)).matches("((^|\n)\\p{Space}*--([^\n\r])*\r?)*$")) {
                Matcher m = Pattern.compile("((?:^|\n)\\p{Space}*)(--[ ]?[ ]?)").matcher(result);
                int offset = 0;
                while (m.find()) {
                    String beginString = m.start(2) > 0 ? result.substring(0, m.start(2) - offset) : "";
                    result = String.valueOf(beginString) + result.substring(m.end(2) - offset);
                    offset += m.group(2).length();
                    if (m.start() + offsetLineBegin < selectionOffsetBegin) {
                        newSelectionOffsetBegin -= m.group(2).length();
                    }
                    newSelectionOffsetEnd -= m.group(2).length();
                }
            } else {
                Matcher m = Pattern.compile("(^|(?:[\r]?[\n]))").matcher(result);
                int offset = 0;
                while (m.find()) {
                    String beginString = m.start() > 0 ? result.substring(0, m.end() + offset) : "";
                    result = String.valueOf(beginString) + "--  " + result.substring(m.end() + offset);
                    offset += "--  ".length();
                    if (m.start() + offsetLineBegin < selectionOffsetBegin) {
                        newSelectionOffsetBegin += "--  ".length();
                    }
                    newSelectionOffsetEnd += "--  ".length();
                }
            }
            document.replace(offsetLineBegin, offsetLineEnd - offsetLineBegin, result);
            ((TextViewer)this.fEditor.getSourceViewerPublic()).setSelectedRange(newSelectionOffsetBegin, newSelectionOffsetEnd - newSelectionOffsetBegin);
        }
        catch (BadLocationException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }
}

