/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.utils.ProjectUtils;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.jobs.GNATstubJob;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AdaActionGenerateBody
extends TextEditorAction {
    protected AdaEditor fEditor;

    public AdaActionGenerateBody(ResourceBundle bundle, String prefix, AdaEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.fEditor = editor;
    }

    public void run() {
        boolean overwrite;
        IProject project = this.fEditor.getProject();
        String thisFile = this.fEditor.getFile().getName();
        String location = this.fEditor.getFile().getLocation().toString();
        location = location.substring(0, location.lastIndexOf("/"));
        String specSuffix = ProjectUtils.specSuffixAda((IProject)project);
        String bodySuffix = ProjectUtils.bodySuffixAda((IProject)project);
        String bodyFileName = String.valueOf(this.basename(thisFile)) + "." + bodySuffix;
        if (!this.extension(thisFile).equalsIgnoreCase(specSuffix)) {
            MessageDialog.openError(null, (String)"Generate Package Body", (String)("The file name extension of '" + thisFile + "' is not consistent with a file containing a package declaration."));
            return;
        }
        File file = new File(String.valueOf(location) + "/" + bodyFileName);
        if (file.exists() && !(overwrite = MessageDialog.openConfirm(null, (String)"Generate Package Body", (String)("File '" + bodyFileName + "' already exists.\nIs it OK to overwrite it with a new body?")))) {
            return;
        }
        if (this.fEditor.isDirty()) {
            this.fEditor.doSave(null);
        }
        GNATstubJob job = new GNATstubJob(location, thisFile, bodyFileName, project);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new NewFileJobAdapter(location, bodyFileName, project));
    }

    protected String basename(String input) {
        int dot = input.lastIndexOf(46);
        int sep = input.lastIndexOf(47);
        return input.substring(sep + 1, dot);
    }

    protected String extension(String input) {
        int dot = input.lastIndexOf(46);
        return input.substring(dot + 1, input.length());
    }

    public class NewFileJobAdapter
    extends JobChangeAdapter {
        private String newFile;
        private String location;
        private IProject project;

        public NewFileJobAdapter(String location, String newFile, IProject project) {
            this.newFile = newFile;
            this.location = location;
            this.project = project;
        }

        public void done(IJobChangeEvent event) {
            File file = new File(String.valueOf(this.location) + "/" + this.newFile);
            if (file.exists()) {
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    return;
                }
                String projectPath = this.project.getFullPath().toString();
                int loc = this.location.lastIndexOf(projectPath) + projectPath.length();
                String parentFolderPath = this.location.substring(loc);
                if (parentFolderPath.equals("")) {
                    new OpenEditorJob(this.project.getFile((IPath)new Path(this.newFile))).schedule();
                } else {
                    new OpenEditorJob(this.project.getFile((IPath)new Path(String.valueOf(parentFolderPath) + "/" + this.newFile))).schedule();
                }
            }
        }
    }

    public class OpenEditorJob
    extends UIJob {
        protected IFile file;

        public OpenEditorJob(IFile file) {
            super("Opening New Ada File");
            this.file = file;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            AdaFile adafile = new AdaFile(this.file);
            AdaLocation location = AdaLocation.fromEclipse((AdaFile)adafile, (int)0, (int)0);
            try {
                GNATbenchUIPlugin.getDefault().openEditor(location);
            }
            catch (Throwable throwable) {
                return new Status(4, GNATbenchUIPlugin.getId(), 0, "Command failed due to an exception", null);
            }
            return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
        }
    }
}

