/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.IGPRListener;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.gpswrappers.ScenarioVariable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class GPRScenarioVariablesView
extends ViewPart
implements IGPRListener,
DisposeListener {
    private Composite fParent;
    private Composite fControl;
    private Display fDisplay;

    public GPRScenarioVariablesView() {
        GNATbenchKernel.getDefault().addGPRListener((IGPRListener)this);
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.fDisplay = parent.getDisplay();
        this.update();
    }

    public void update() {
        ScenarioVariable[] vars;
        if (this.fControl != null) {
            this.fControl.dispose();
            this.fControl = null;
        }
        this.fControl = new Composite(this.fParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.fControl.setLayout((Layout)layout);
        GPRProject gprProject = GNATbenchKernel.getDefault().getWorkspaceProject();
        try {
            gprProject.loadScenarioVariables();
            vars = gprProject.getScenarioVariables();
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return;
        }
        int i = 0;
        while (i < vars.length) {
            new Label(this.fControl, 0).setText(vars[i].getName());
            Combo combo = new Combo(this.fControl, 4);
            int j = 0;
            while (j < vars[i].getPossibleValues().length) {
                combo.add(vars[i].getPossibleValues()[j]);
                ++j;
            }
            combo.setText(vars[i].getValue());
            combo.addModifyListener((ModifyListener)new ScenarioVariableChange(vars[i]));
            combo.setLayoutData((Object)new GridData(768));
            ++i;
        }
        this.fParent.layout();
        this.fParent.addDisposeListener((DisposeListener)this);
    }

    public void setFocus() {
    }

    public void workspaceRecomputed() {
        this.fDisplay.asyncExec(new Runnable(){

            public void run() {
                GPRScenarioVariablesView.this.update();
            }
        });
    }

    public void widgetDisposed(DisposeEvent e) {
        GNATbenchKernel.getDefault().removeGPSListener((IGPRListener)this);
    }

    private class ScenarioVariableChange
    implements ModifyListener {
        ScenarioVariable fVar;

        public ScenarioVariableChange(ScenarioVariable var) {
            this.fVar = var;
        }

        public void modifyText(ModifyEvent e) {
            Combo source = (Combo)e.getSource();
            try {
                this.fVar.setValue(source.getText());
            }
            catch (GNATbenchCoreException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
            }
        }
    }
}

