/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AbstractAdaEditor;
import com.adacore.gnatbench.core.adaeditor.AdaFileEditorInput;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import com.adacore.gnatbench.ui.adaeditor.AdaSyntaxHighlighting;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GNATbenchUIPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    private static GNATbenchUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private AdaSyntaxHighlighting codeScanner;
    public static final String LOCATION_MARKER_TEXT = "AdaLocationMarker.Text";
    public static final String LOCATION_MARKER_COLUMN = "AdaLocationMarker.Column";
    public static final String ERROR_MARKER_NUMBER = "AdaErrorMarker.Number";
    private Shell fHiddenShell;
    public static final String GENERIC_ERROR_ICON = "generic_error_message";
    private LinkedList fTimes = new LinkedList();

    public GNATbenchUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.eclipse.adacore.gnatbench.ui.GNATbenchPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void addImage(String key, String basePath, String name) {
        this.getImageRegistry().put(key, this.createImage(basePath, name));
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String basePath, String name) {
        URL baseURL;
        try {
            baseURL = new URL(this.getBundle().getEntry(basePath), name);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        return ImageDescriptor.createFromURL((URL)baseURL);
    }

    private Image createImage(String basePath, String name) {
        return this.getImageDescriptor(basePath, name).createImage();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static GNATbenchUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = GNATbenchUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public AdaSyntaxHighlighting getCodeScanner() {
        if (this.codeScanner == null) {
            this.codeScanner = new AdaSyntaxHighlighting();
        }
        return this.codeScanner;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().indexOf("com.adacore") != -1 && this.codeScanner != null) {
            this.codeScanner.updateFromPreferences();
        }
    }

    public IEditorPart openEditor(AdaLocation location) throws PartInitException {
        if (location == null) {
            return null;
        }
        Path thePath = new Path(location.getAdaFile().getOSPath());
        IFile theFile = location.getAdaFile().getFile();
        IEditorPart newEditor = null;
        IEditorDescriptor editorDesc = this.getWorkbench().getEditorRegistry().getDefaultEditor(location.getAdaFile().getOSPath());
        if (theFile == null || !theFile.exists()) {
            File f = new File(thePath.toOSString());
            if (!f.exists()) {
                return null;
            }
            AdaFileEditorInput input = new AdaFileEditorInput(thePath.toFile(), location.getAdaFile().getProject());
            newEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorDesc.getId());
        } else {
            newEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)theFile, (String)editorDesc.getId());
        }
        if (newEditor instanceof AdaEditor) {
            ((AdaEditor)newEditor).focus(location);
        }
        return newEditor;
    }

    public IMarker createMarker(AdaFile adaFile, String markerType) {
        try {
            IFile file = adaFile.getFile();
            if (file != null) {
                return file.createMarker(markerType);
            }
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void refreshAnnotations(IFile file) {
        if (file == null) {
            return;
        }
        AbstractAdaEditor editor = GNATbenchCorePlugin.getDefault().getEditor(file);
        if (editor == null || !(editor instanceof AdaEditor)) {
            return;
        }
        AdaEditor adaEditor = (AdaEditor)editor;
        if (file.equals((Object)adaEditor.getFile())) {
            adaEditor.updateAnnotations();
        }
    }

    public void refreshEditors() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i].getEditor(false);
            if (editor instanceof AdaEditor) {
                ((AdaEditor)editor).refreshWidget();
            }
            ++i;
        }
    }

    public void pushTime() {
        this.fTimes.add(new Long(new Date().getTime()));
    }

    public void popTime(String label) {
        Long lastTime = (Long)this.fTimes.getLast();
        this.fTimes.removeLast();
        long timeSpent = new Date().getTime() - lastTime;
        System.out.println(String.valueOf(label) + ": " + timeSpent);
    }

    public static String getId() {
        return "com.adacore.gnatbench.ui";
    }

    public AdaEditor getActiveEditor() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null || !(editor instanceof AdaEditor)) {
            return null;
        }
        return (AdaEditor)editor;
    }

    public void hideEclipse() {
        this.fHiddenShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        this.fHiddenShell.setVisible(false);
    }

    public void showEclipse() {
        this.fHiddenShell.setVisible(true);
    }

    public String getPluginPath() {
        try {
            String path = Platform.asLocalURL((URL)this.getBundle().getEntry("/")).getPath();
            if (Platform.getOS().equals("win32")) {
                return path.substring(1);
            }
            return path;
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return "";
        }
    }

    public void cleanLastCompilation(IProject project) {
        try {
            IMarker[] markers = project.findMarkers("com.adacore.gnatbench.core.AdaErrorMarker", true, 2);
            HashMap resourceMap = new HashMap();
            int i = 0;
            while (i < markers.length) {
                resourceMap.put(markers[i].getResource(), null);
                markers[i].delete();
                ++i;
            }
            Iterator iter = resourceMap.keySet().iterator();
            while (iter.hasNext()) {
                IResource resource = (IResource)iter.next();
                AdaEditor editor = (AdaEditor)GNATbenchCorePlugin.getDefault().getEditor((IFile)resource);
                if (editor == null) continue;
                editor.updateAnnotations();
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }
}

