/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class GNATbenchProperties
extends PropertyPage {
    private Text fText;
    private Button fIsRootProject;

    protected IProject getProject() {
        if (this.getElement() instanceof IProject) {
            return (IProject)this.getElement();
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        control.setLayout((Layout)layout);
        Label label = new Label(control, 0);
        label.setText("GPS project file");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.fText = new Text(control, 2048);
        this.fText.setLayoutData((Object)data);
        String projectName = GPRProject.getGPRPath((IProject)this.getProject());
        if (projectName == null) {
            projectName = "";
        }
        this.fText.setText(projectName);
        Button b = new Button(control, 8);
        b.setText("Search Project");
        b.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                class WorkspaceFileDialog
                extends Dialog {
                    String result = "";

                    public WorkspaceFileDialog(Shell parent) {
                        super(parent);
                    }

                    private void searchInContainer(IContainer container, List list) throws CoreException {
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            IFile file;
                            IResource element = members[i];
                            if (element instanceof IContainer) {
                                this.searchInContainer((IContainer)element, list);
                            } else if (element instanceof IFile && "gpr".equals((file = (IFile)element).getFileExtension())) {
                                list.add(file.getFullPath().removeFirstSegments(1).toOSString());
                            }
                            ++i;
                        }
                    }

                    public String open() {
                        Shell parent = this.getParent();
                        Shell shell = new Shell(parent, 67680);
                        shell.setText(this.getText());
                        GridLayout layout = new GridLayout();
                        layout.numColumns = 1;
                        shell.setLayout((Layout)layout);
                        Label label = new Label((Composite)shell, 0x1000000);
                        label.setText("Please select a GNAT Project");
                        List l = new List((Composite)shell, 2052);
                        GridData data = new GridData();
                        data.horizontalSpan = 2;
                        data.horizontalAlignment = 4;
                        data.verticalAlignment = 4;
                        l.setLayoutData((Object)data);
                        try {
                            this.searchInContainer((IContainer)GNATbenchProperties.this.getProject(), l);
                        }
                        catch (CoreException e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                        Composite buttonsComp = new Composite((Composite)shell, 0);
                        GridLayout g1 = new GridLayout();
                        g1.makeColumnsEqualWidth = false;
                        g1.numColumns = 2;
                        buttonsComp.setLayout((Layout)g1);
                        Composite emptyComp = new Composite(buttonsComp, 0);
                        data = new GridData();
                        data.horizontalAlignment = 4;
                        emptyComp.setLayoutData((Object)data);
                        Composite filledComp = new Composite(buttonsComp, 0);
                        GridLayout g2 = new GridLayout();
                        g2.makeColumnsEqualWidth = true;
                        g2.numColumns = 2;
                        filledComp.setLayout((Layout)g2);
                        data = new GridData();
                        data.horizontalAlignment = 4;
                        Button b = new Button(filledComp, 8);
                        b.setText("OK");
                        b.setLayoutData((Object)data);
                        b.addMouseListener(new MouseListener(this, l, shell){
                            final /* synthetic */ WorkspaceFileDialog this$2;
                            private final /* synthetic */ List val$l;
                            private final /* synthetic */ Shell val$shell;
                            {
                                this.this$2 = workspaceFileDialog;
                                this.val$l = list;
                                this.val$shell = shell;
                            }

                            public void mouseDoubleClick(MouseEvent e) {
                            }

                            public void mouseDown(MouseEvent e) {
                            }

                            public void mouseUp(MouseEvent e) {
                                if (this.val$l.getSelection().length >= 1) {
                                    this.this$2.result = this.val$l.getSelection()[0];
                                }
                                this.val$shell.close();
                            }
                        });
                        data = new GridData();
                        data.horizontalAlignment = 4;
                        b = new Button(filledComp, 8);
                        b.setText("Cancel");
                        b.setLayoutData((Object)data);
                        b.addMouseListener(new MouseListener(this, shell){
                            final /* synthetic */ WorkspaceFileDialog this$2;
                            private final /* synthetic */ Shell val$shell;
                            {
                                this.this$2 = workspaceFileDialog;
                                this.val$shell = shell;
                            }

                            public void mouseDoubleClick(MouseEvent e) {
                            }

                            public void mouseDown(MouseEvent e) {
                            }

                            public void mouseUp(MouseEvent e) {
                                this.this$2.result = GNATbenchProperties.access$0(1.access$0(WorkspaceFileDialog.access$0(this.this$2))).getText();
                                this.val$shell.close();
                            }
                        });
                        shell.pack();
                        shell.open();
                        Display display = parent.getDisplay();
                        while (!shell.isDisposed()) {
                            if (display.readAndDispatch()) continue;
                            display.sleep();
                        }
                        return this.result;
                    }

                    static /* synthetic */ 1 access$0(WorkspaceFileDialog workspaceFileDialog) {
                        return workspaceFileDialog.this;
                    }
                }
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(GNATbenchProperties.this.getShell());
                dialog.setText("Select a GNAT project file");
                String path = dialog.open();
                if (path != null) {
                    GNATbenchProperties.this.fText.setText(path);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        b = new Button(control, 8);
        b.setText("Browse");
        b.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FileDialog dialog = new FileDialog(GNATbenchProperties.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.gpr"});
                String path = dialog.open();
                if (path != null) {
                    GNATbenchProperties.this.fText.setText(path);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        boolean isRootProject = GPRProject.isRootProject((IProject)this.getProject());
        Label label2 = new Label(control, 0);
        label2.setText("Is root project ");
        this.fIsRootProject = new Button(control, 32);
        this.fIsRootProject.setSelection(isRootProject);
        return control;
    }

    public boolean performOk() {
        GPRProject.setGPRPath((IProject)this.getProject(), (String)this.fText.getText());
        GPRProject.setRootProject((IProject)this.getProject(), (boolean)this.fIsRootProject.getSelection());
        GNATbenchKernel.getDefault().fullWorkspaceRecompute();
        return true;
    }
}

