/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt.wizards.newProject;

import com.adacore.gnatbench.cdt.wizards.newProject.AbstractNewAdaProject;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NewAdaDebugReleaseProject
extends AbstractNewAdaProject {
    protected boolean createGPRfile(String projectName, String mainUnitName, String builderName) {
        String builderNameforIDE;
        String projFileName = new String(String.valueOf(projectName) + ".gpr");
        IFile file = this.newProject.getFile((IPath)new Path(projFileName));
        String languageChoice = this.configPage.useAda2005() ? "-gnat05" : "-gnat95";
        String string = builderNameforIDE = builderName.equalsIgnoreCase("gprmake") ? "gnatmake" : builderName;
        if (!file.exists()) {
            String newGPRfile = "project " + projectName + " is\n" + "\n" + "\ttype Build_Modes is (\"Release\", \"Debug\");\n" + "\tMode : Build_Modes := external (\"BUILD\", \"Debug\");\n" + "\n" + "\tfor Main use (\"" + mainUnitName + ".adb\");\n" + "\n" + "\tfor Exec_Dir use \".\";\n" + "\n" + "\tcase Mode is\n" + "\t\twhen \"Debug\" =>\n" + "\t\t\tfor Object_Dir use \"debug_objs\";\n" + "\t\twhen \"Release\" =>\n" + "\t\t\tfor Object_Dir use \"release_objs\";\n" + "\tend case;\n" + "\n" + "\tpackage Compiler is\n" + "\t\tcase Mode is\n" + "\t\t\twhen \"Debug\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use\n" + "\t\t\t\t\t\t(\"-g\", \"-gnato\", \"-gnatwa\", \"-fstack-check\", \"" + languageChoice + "\");\n" + "\t\t\twhen \"Release\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use (\"-O2\", \"" + languageChoice + "\");\n" + "\t\tend case;\n" + "\tend Compiler;\n" + "\n" + "\tpackage Builder is\n" + "\t\tcase Mode is\n" + "\t\t\twhen \"Debug\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use (\"-g\");\n" + "\t\t\twhen \"Release\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use (\"\");\n" + "\t\tend case;\n" + "\tend Builder;\n" + "\n" + "\tpackage IDE is\n" + "\t\tfor Compiler_Command(\"Ada\") use \"" + builderNameforIDE + "\";\n" + "\tend IDE;\n" + "\n" + "end " + projectName + ";";
            try {
                file.create((InputStream)new StringBufferInputStream(newGPRfile), true, null);
            }
            catch (CoreException e) {
                this.displayError("Create GNAT project", "Inserting project file '" + projFileName + "' to project " + projectName + " failed");
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }
        return true;
    }

    protected boolean setupProject(IProject project, String mainUnitName, String builderName) {
        IFolder debugFolder = this.newProject.getFolder((IPath)new Path("debug_objs"));
        try {
            debugFolder.create(true, true, null);
        }
        catch (CoreException e) {
            this.displayError("Create GNAT project", "Inserting debug object dir to project " + project.getName() + " failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
        IFolder releaseFolder = this.newProject.getFolder((IPath)new Path("release_objs"));
        try {
            releaseFolder.create(true, true, null);
        }
        catch (CoreException e) {
            this.displayError("Create GNAT project", "Inserting release object dir to project " + project.getName() + " failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
        return true;
    }
}

