/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt.wizards.newProject;

import com.adacore.gnatbench.core.utils.SyntaxUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AdaConfigPage
extends WizardPage {
    private Text unitNameWidget;
    private String builderName = "";
    private String fmainUnitName = "";
    private Button fCreateMainProgramFile;
    private Button fUseAda2005;
    private Button mainIsHelloWorld;
    private Text buildCommandWidget;
    private String foreignBuildCommand = "";
    private Text cleanCommandWidget;
    private String foreignCleanCommand = "";
    private Text analyzeCommandWidget;
    private String foreignAnalyzeCommand = "";
    private Text autoBuildCommandWidget;
    private String foreignAutoBuildCommand = "";

    public AdaConfigPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Configure Ada main subprogram and make language configuration choices");
    }

    public boolean shouldCreateMainFile() {
        return this.fCreateMainProgramFile.getSelection();
    }

    public boolean requestedHelloWorld() {
        return this.mainIsHelloWorld.getSelection();
    }

    public String unitName() {
        return this.fmainUnitName;
    }

    public String builderName() {
        return this.builderName;
    }

    public boolean useAda2005() {
        return this.fUseAda2005.getSelection();
    }

    public boolean isForeignBuilder() {
        return !this.isGNATProBuilder(this.builderName);
    }

    public String getForeignBuildCommand() {
        return this.foreignBuildCommand;
    }

    public String getForeignCleanCommand() {
        return this.foreignCleanCommand;
    }

    public String getForeignAnalyzeCommand() {
        return this.foreignAnalyzeCommand;
    }

    public String getForeignAutoBuildCommand() {
        return this.foreignAutoBuildCommand;
    }

    public boolean isPageComplete() {
        return this.isCurrentPage() && SyntaxUtils.isAdaIdentifier((String)this.fmainUnitName) && !this.builderName.equals("") && (this.isGNATProBuilder(this.builderName) || this.allForeignCommandsEntered());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.unitNameWidget.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite baseComp = new Composite(parent, 0);
        this.setControl((Control)baseComp);
        GridLayout topLayout = new GridLayout();
        baseComp.setLayout((Layout)topLayout);
        Composite projectComp = new Composite(baseComp, 0);
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 2;
        projectLayout.marginHeight = 0;
        projectLayout.marginWidth = 0;
        projectComp.setLayout((Layout)projectLayout);
        projectComp.setLayoutData((Object)new GridData(768));
        GridData maingd = new GridData(768);
        this.fCreateMainProgramFile = new Button(projectComp, 32);
        this.fCreateMainProgramFile.setText("Generate file containing Ada main subprogram");
        this.fCreateMainProgramFile.setSelection(true);
        maingd = new GridData();
        maingd.horizontalSpan = 2;
        this.fCreateMainProgramFile.setLayoutData((Object)maingd);
        this.mainIsHelloWorld = new Button(projectComp, 32);
        this.mainIsHelloWorld.setText("Generate Ada main subprogram as Hello World application");
        this.mainIsHelloWorld.setSelection(false);
        maingd = new GridData();
        maingd.horizontalSpan = 2;
        this.mainIsHelloWorld.setLayoutData((Object)maingd);
        this.mainIsHelloWorld.setEnabled(this.fCreateMainProgramFile.getSelection());
        this.fCreateMainProgramFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AdaConfigPage.this.mainIsHelloWorld.setEnabled(AdaConfigPage.this.fCreateMainProgramFile.getSelection());
            }
        });
        Composite locationComp = new Composite(baseComp, 0);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 2;
        locationLayout.marginHeight = 1;
        locationLayout.marginWidth = 1;
        locationComp.setLayout((Layout)locationLayout);
        GridData gd = new GridData(768);
        locationComp.setLayoutData((Object)gd);
        Label mainUnitLabel = new Label(locationComp, 0);
        mainUnitLabel.setText("Name of the Ada main subprogram unit (not the file name):");
        gd = new GridData();
        gd.horizontalSpan = 2;
        mainUnitLabel.setLayoutData((Object)gd);
        this.unitNameWidget = new Text(locationComp, 2052);
        this.unitNameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.fmainUnitName = new String(((Text)e.getSource()).getText().trim());
                if (AdaConfigPage.this.fmainUnitName.equals("")) {
                    AdaConfigPage.this.setErrorMessage(null);
                    return;
                }
                if (!SyntaxUtils.isAdaIdentifier((String)AdaConfigPage.this.fmainUnitName)) {
                    AdaConfigPage.this.setErrorMessage("Main subprogram names must conform to Ada identifier rules");
                    return;
                }
                AdaConfigPage.this.setErrorMessage(null);
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        gd = new GridData(768);
        this.unitNameWidget.setLayoutData((Object)gd);
        this.fUseAda2005 = new Button(locationComp, 32);
        this.fUseAda2005.setText("Build using Ada 2005");
        this.fUseAda2005.setSelection(false);
        maingd = new GridData();
        maingd.horizontalSpan = 2;
        maingd.verticalIndent = 30;
        this.fUseAda2005.setLayoutData((Object)maingd);
        Label toolNameLabel = new Label(locationComp, 0);
        toolNameLabel.setText("Name of the Ada toolchain:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        toolNameLabel.setLayoutData((Object)gd);
        final Combo toolName = new Combo(baseComp, 4);
        toolName.add("gnatmake");
        toolName.add("gnaampmake");
        toolName.add("erc32-elf-gnatmake");
        toolName.add("leon-elf-gnatmake");
        toolName.add("powerpc-elf-gnatmake");
        toolName.add("powerpc-elf-lynxos-gnatmake");
        toolName.add("powerpc-xcoff-lynxos-gnatmake");
        toolName.setText("select or enter a builder name");
        toolName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.builderName = new String(toolName.getText()).trim();
                if (!AdaConfigPage.this.builderName.equals("") && !AdaConfigPage.this.isGNATProBuilder(AdaConfigPage.this.builderName)) {
                    AdaConfigPage.this.enableForeignCommandEntries();
                } else {
                    AdaConfigPage.this.disableForeignCommandEntries();
                }
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        toolName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdaConfigPage.this.builderName = new String(toolName.getText());
                AdaConfigPage.this.disableForeignCommandEntries();
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        toolName.setLayoutData((Object)new GridData(768));
        toolName.setEnabled(true);
        Label buildCommandLabel = new Label(baseComp, 0);
        buildCommandLabel.setText("The complete command to do a full build:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        buildCommandLabel.setLayoutData((Object)gd);
        this.buildCommandWidget = new Text(baseComp, 2052);
        this.buildCommandWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.foreignBuildCommand = new String(((Text)e.getSource()).getText().trim());
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        gd = new GridData(768);
        this.buildCommandWidget.setLayoutData((Object)gd);
        this.buildCommandWidget.setEnabled(false);
        Label cleanCommandLabel = new Label(baseComp, 0);
        cleanCommandLabel.setText("The complete command to clean a project:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        buildCommandLabel.setLayoutData((Object)gd);
        this.cleanCommandWidget = new Text(baseComp, 2052);
        this.cleanCommandWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.foreignCleanCommand = new String(((Text)e.getSource()).getText().trim());
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        gd = new GridData(768);
        this.cleanCommandWidget.setLayoutData((Object)gd);
        this.cleanCommandWidget.setEnabled(false);
        Label analyzeCommandLabel = new Label(baseComp, 0);
        analyzeCommandLabel.setText("The complete command to analyze all sources:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        analyzeCommandLabel.setLayoutData((Object)gd);
        this.analyzeCommandWidget = new Text(baseComp, 2052);
        this.analyzeCommandWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.foreignAnalyzeCommand = new String(((Text)e.getSource()).getText().trim());
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        gd = new GridData(768);
        this.analyzeCommandWidget.setLayoutData((Object)gd);
        this.analyzeCommandWidget.setEnabled(false);
        Label autoBuildCommandLabel = new Label(baseComp, 0);
        autoBuildCommandLabel.setText("The complete command to analyze changed sources:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        autoBuildCommandLabel.setLayoutData((Object)gd);
        this.autoBuildCommandWidget = new Text(baseComp, 2052);
        this.autoBuildCommandWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AdaConfigPage.this.foreignAutoBuildCommand = new String(((Text)e.getSource()).getText().trim());
                if (AdaConfigPage.this.isCurrentPage()) {
                    AdaConfigPage.this.getContainer().updateButtons();
                }
            }
        });
        gd = new GridData(768);
        this.autoBuildCommandWidget.setLayoutData((Object)gd);
        this.autoBuildCommandWidget.setEnabled(false);
    }

    protected void enableForeignCommandEntries() {
        this.buildCommandWidget.setEnabled(true);
        this.cleanCommandWidget.setEnabled(true);
        this.analyzeCommandWidget.setEnabled(true);
        this.autoBuildCommandWidget.setEnabled(true);
    }

    protected void disableForeignCommandEntries() {
        this.buildCommandWidget.setEnabled(false);
        this.cleanCommandWidget.setEnabled(false);
        this.analyzeCommandWidget.setEnabled(false);
        this.autoBuildCommandWidget.setEnabled(false);
    }

    protected boolean isGNATProBuilder(String input) {
        if (input.toLowerCase().endsWith("gnatmake")) {
            return true;
        }
        return input.toLowerCase().endsWith("gnaampmake");
    }

    protected boolean allForeignCommandsEntered() {
        if (this.foreignBuildCommand.equals("")) {
            return false;
        }
        if (this.foreignCleanCommand.equals("")) {
            return false;
        }
        if (this.foreignAnalyzeCommand.equals("")) {
            return false;
        }
        return !this.foreignAutoBuildCommand.equals("");
    }
}

