/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt.wizards.newProject;

import com.adacore.gnatbench.cdt.wizards.newProject.AdaConfigPage;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.utils.SyntaxUtils;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public abstract class AbstractNewAdaProject
extends Wizard
implements INewWizard {
    protected AdaConfigPage configPage;
    protected IProject newProject;
    protected RestrictedWizardNewProjectCreationPage newProjPage;

    public void addPages() {
        this.newProjPage = new RestrictedWizardNewProjectCreationPage("NewGNATProPage");
        this.newProjPage.setDescription("Specify the name of the new project and where it will be located.");
        this.newProjPage.setTitle("New Ada Project");
        this.addPage((IWizardPage)this.newProjPage);
        this.configPage = new AdaConfigPage("Ada Language Settings");
        this.addPage((IWizardPage)this.configPage);
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract boolean setupProject(IProject var1, String var2, String var3);

    protected abstract boolean createGPRfile(String var1, String var2, String var3);

    public boolean performFinish() {
        if (!this.configPage.isPageComplete()) {
            return false;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (!AbstractNewAdaProject.this.createNewAdaProject()) {
                    return;
                }
                if (!AbstractNewAdaProject.this.createGPRfile(AbstractNewAdaProject.this.newProject.getName(), AbstractNewAdaProject.this.configPage.unitName(), AbstractNewAdaProject.this.configPage.builderName())) {
                    return;
                }
                if (!AbstractNewAdaProject.this.createMakefile(AbstractNewAdaProject.this.newProject)) {
                    return;
                }
                if (!AbstractNewAdaProject.this.setupProject(AbstractNewAdaProject.this.newProject, AbstractNewAdaProject.this.configPage.unitName(), AbstractNewAdaProject.this.configPage.builderName())) {
                    return;
                }
                if (AbstractNewAdaProject.this.configPage.shouldCreateMainFile() && !AbstractNewAdaProject.this.createMainFile(AbstractNewAdaProject.this.configPage.unitName())) {
                    return;
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError("Create New Ada Project", "Project creation failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean createMakefile(IProject project) {
        IFile file = project.getFile((IPath)new Path("/Makefile"));
        String makeFile = this.configPage.isForeignBuilder() ? GNATbenchIncrementalBuilder.makefileFromStrings((String)this.configPage.getForeignBuildCommand(), (String)this.configPage.getForeignCleanCommand(), (String)this.configPage.getForeignAnalyzeCommand(), (String)this.configPage.getForeignAutoBuildCommand()) : GNATbenchIncrementalBuilder.makefileFromBuilder((String)this.configPage.builderName());
        try {
            file.create((InputStream)new StringBufferInputStream(makeFile), true, null);
        }
        catch (CoreException e) {
            this.displayError("Create New Ada Project", "Inserting makefile failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean createMainFile(String mainUnitName) {
        String mainFileName = new String(String.valueOf(mainUnitName) + ".adb");
        IFile file = this.newProject.getFile((IPath)new Path(mainFileName));
        String newMainContent = this.configPage.requestedHelloWorld() ? "with GNAT.IO;  use GNAT.IO;\nprocedure " + mainUnitName + " is\n" + "begin\n" + "   Put_Line (\"Hello World!\");\n" + "end " + mainUnitName + ";\n" : "procedure " + mainUnitName + " is\n" + "begin\n" + "   null; -- remove this null statement and enter your code here\n" + "end " + mainUnitName + ";\n";
        if (!file.exists()) {
            try {
                file.create((InputStream)new StringBufferInputStream(newMainContent), true, null);
            }
            catch (CoreException e) {
                this.displayError("Create New Ada Project", "Inserting main program file '" + mainFileName + "' to project " + this.newProject.getName() + " failed");
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return false;
            }
        } else {
            this.displayError("Create New Ada Project", "A file named '" + mainFileName + "' in project " + this.newProject.getName() + " already exists");
            return false;
        }
        return true;
    }

    protected boolean createNewAdaProject() {
        IPath newPath;
        IProject newProjectHandle = this.newProjPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.newProjPage.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        try {
            this.createProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
            GNATbenchProjectNature.addNature((IProject)newProjectHandle);
        }
        catch (OperationCanceledException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        GPRProject.setRootProject((IProject)newProjectHandle, (boolean)true);
        String projPath = String.valueOf(newProjectHandle.getName()) + ".gpr";
        GPRProject.setGPRPath((IProject)newProjectHandle, (String)projPath);
        this.newProject = newProjectHandle;
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    protected void displayError(String title, String msg) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
    }

    public class RestrictedWizardNewProjectCreationPage
    extends WizardNewProjectCreationPage {
        public RestrictedWizardNewProjectCreationPage(String pageName) {
            super(pageName);
        }

        protected boolean validatePage() {
            super.validatePage();
            if (!SyntaxUtils.isAdaIdentifier((String)this.getProjectName())) {
                this.setErrorMessage("Project names must conform to Ada identifier rules");
                return false;
            }
            return true;
        }
    }
}

