/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt.wizards.conversion;

import com.adacore.gnatbench.cdt.wizards.conversion.ConvertedAdaProjectWizard;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.ui.utils.DisplayUtils;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GNATbenchProjectConvertor
implements IObjectActionDelegate {
    StructuredSelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Iterator iter = this.fSelection.iterator();
        while (iter.hasNext()) {
            String projFileName;
            IFile file;
            IProject project = (IProject)iter.next();
            String projectFileName = String.valueOf(project.getName()) + ".gpr";
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            ISelection selection = window.getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection) {
                selectionToPass = (IStructuredSelection)selection;
            }
            if ((file = project.getFile((IPath)new Path(projFileName = new String(String.valueOf(project.getName()) + ".gpr")))).exists()) {
                DisplayUtils.displayError((String)"Convert to GNAT Project", (String)("The GNAT project file '" + projFileName + "' already exists!"));
                return;
            }
            IFile makefile = project.getFile((IPath)new Path("Makefile"));
            if (makefile.exists()) {
                DisplayUtils.displayError((String)"Convert to GNAT Project", (String)"A makefile named 'Makefile' already exists!");
                return;
            }
            ConvertedAdaProjectWizard wizard = new ConvertedAdaProjectWizard();
            wizard.init(workbench, (IStructuredSelection)selectionToPass);
            wizard.setForcePreviousAndNextButtons(true);
            WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            try {
                GNATbenchProjectNature.addNature((IProject)project);
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return;
            }
            GPRProject.setRootProject((IProject)project, (boolean)true);
            GPRProject.setGPRPath((IProject)project, (String)projectFileName);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = (StructuredSelection)selection;
    }
}

