/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class GNATbenchCDTPlugin
extends AbstractUIPlugin {
    private static GNATbenchCDTPlugin plugin;
    protected ImageRegistry fImageRegistry;
    protected ResourceBundle resourceBundle;
    public static final String NEW_ADA_PROJ = "new_ada_project";
    public static final String NEW_BASIC_FILES = "new_basic_files";

    public GNATbenchCDTPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.eclipse.adacore.gnatbench.cdt.GnatbenchPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static GNATbenchCDTPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new UIJob("loading CDT images"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                GNATbenchCDTPlugin.this.fImageRegistry = new ImageRegistry();
                GNATbenchCDTPlugin.this.addImage(GNATbenchCDTPlugin.NEW_ADA_PROJ, "img/", "newada_app.gif");
                GNATbenchCDTPlugin.this.addImage(GNATbenchCDTPlugin.NEW_BASIC_FILES, "img/", "new_basic_file.gif");
                return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
            }
        }.schedule();
    }

    public void addImage(String key, String basePath, String name) {
        this.fImageRegistry.put(key, this.createImage(basePath, name));
    }

    public Image getImage(String key) {
        return this.fImageRegistry.get(key);
    }

    public ImageDescriptor getImageDescriptor(String basePath, String name) {
        URL baseURL;
        try {
            baseURL = new URL(this.getBundle().getEntry(basePath), name);
        }
        catch (MalformedURLException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return null;
        }
        return ImageDescriptor.createFromURL((URL)baseURL);
    }

    private Image createImage(String basePath, String name) {
        return this.getImageDescriptor(basePath, name).createImage();
    }
}

