/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.cdt;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.builder.IGNATbenchProjectNatureContribution;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class GNATbenchCDTNatureContribution
implements IGNATbenchProjectNatureContribution {
    public void configure(IProject project) {
        try {
            this.enableCDTDebugger(project);
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(GNATbenchIncrementalBuilder.BUILDER_ID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName(GNATbenchIncrementalBuilder.BUILDER_ID);
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 1, commands.length);
                newCommands[0] = command;
                desc.setBuildSpec(newCommands);
                project.setDescription(desc, null);
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    private void enableCDTDebugger(IProject project) throws CoreException {
        CProjectNature.addCNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        ICDescriptorOperation op = new ICDescriptorOperation(){

            public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                descriptor.remove("org.eclipse.cdt.core.BinaryParser");
                GNATbenchCDTNatureContribution.this.enaleAllBinaryParsers(descriptor);
            }
        };
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(project, op, null);
    }

    private void enaleAllBinaryParsers(ICDescriptor descriptor) throws CoreException {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int k = 0;
            while (k < extensions.length) {
                descriptor.create("org.eclipse.cdt.core.BinaryParser", extensions[k].getUniqueIdentifier());
                ++k;
            }
        }
    }
}

