/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.make;

import com.adacore.gnatbench.core.builder.GNATbenchBuilderJob;
import com.adacore.gnatbench.core.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.make.IMakefileTarget;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.IJobChangeListener;

public class MakefileTarget
extends PlatformObject
implements IMakefileTarget {
    protected IProject project;
    protected String name;
    protected String description;

    public MakefileTarget(IProject project, String name, String description) {
        this.project = project;
        this.name = name;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public boolean invoke(String[] args) {
        String gprFileLocation = GPRProject.getGPROSPath(this.project);
        String gprLocationMacro = "GPRPATH=\"" + gprFileLocation + "\"";
        StringBuffer params = new StringBuffer("");
        if (args != null) {
            int k = 0;
            while (k < args.length) {
                params.append(String.valueOf(args[k]) + " ");
                ++k;
            }
        }
        String command = "make " + gprLocationMacro + " " + params + this.name;
        GNATbenchBuilderJob job = new GNATbenchBuilderJob(command, this.project);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new GNATbenchIncrementalBuilder.JobCompleteAdapter(this.project));
        return true;
    }
}

