/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.make;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.make.IMakefile;
import com.adacore.gnatbench.core.make.IMakefileTarget;
import com.adacore.gnatbench.core.make.MakefileTarget;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;

public class Makefile
extends PlatformObject
implements IMakefile {
    private IProject project;
    private Map allTargets = new HashMap();
    private static final String rule = "^[a-zA-Z_0-9]*:.*$";
    private static final String comment = "#.*$";

    public Makefile(IProject project) {
        this.project = project;
        this.readFile(project.getFile("Makefile"));
    }

    public IMakefileTarget[] targets() {
        IMakefileTarget[] result = new IMakefileTarget[this.allTargets.size()];
        int k = 0;
        Iterator iter = this.allTargets.values().iterator();
        while (iter.hasNext()) {
            result[k] = (IMakefileTarget)iter.next();
            ++k;
        }
        return result;
    }

    public IMakefileTarget target(String name) {
        if (this.allTargets.containsKey(name)) {
            return (IMakefileTarget)this.allTargets.get(name);
        }
        return null;
    }

    public IProject project() {
        return this.project;
    }

    private void readFile(IFile makefile) {
        File file = new File(this.project.getLocation() + "/" + "Makefile");
        DataInputStream dis = null;
        try {
            StringBuffer description = new StringBuffer("");
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            while (dis.available() != 0) {
                String line = dis.readLine();
                if (line.startsWith("\t")) continue;
                if (line.equals("")) {
                    description = new StringBuffer("");
                    continue;
                }
                if (line.matches(comment)) {
                    description.append(String.valueOf(line.substring(1).trim()) + " ");
                    continue;
                }
                if (!line.matches(rule)) continue;
                int colonPos = line.indexOf(58);
                String targetName = line.substring(0, colonPos);
                MakefileTarget target = new MakefileTarget(this.project, targetName, description.toString());
                this.allTargets.put(targetName, target);
                description = new StringBuffer("");
            }
            dis.close();
        }
        catch (FileNotFoundException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
    }
}

