/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.gpswrappers;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.File;
import com.adacore.gnatbench.core.gpswrappers.ScenarioVariable;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Output.Output_Proc;
import com.adacore.gnatbench.library.Prj.PP.Write_Char_Ap;
import com.adacore.gnatbench.library.Prj.PP.Write_Eol_Ap;
import com.adacore.gnatbench.library.Prj.PP.Write_Str_Ap;
import com.adacore.gnatbench.library.Projects.Abstract_Registry;
import com.adacore.gnatbench.library.Projects.Attribute_Pkg;
import com.adacore.gnatbench.library.Projects.Editor.Editor_Package;
import com.adacore.gnatbench.library.Projects.Error_Report;
import com.adacore.gnatbench.library.Projects.Imported_Project_Iterator;
import com.adacore.gnatbench.library.Projects.Project_Type;
import com.adacore.gnatbench.library.Projects.Projects_Package;
import com.adacore.gnatbench.library.Projects.Registry.Registry_Package;
import com.adacore.gnatbench.library.Projects.Scenario_Variable_Array;
import com.adacore.gnatbench.library.System.OS_Lib.Argument_List;
import com.adacore.gnatbench.library.System.Strings.String_List;
import com.adacore.gnatbench.library.VFS.File_Array;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.jni.AdaString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GPRProject {
    ScenarioVariable[] fScenarioVariables;
    private Project_Type fGPR;
    IProject fEclipseProject;
    LinkedList fGPRErrors = new LinkedList();
    private static int fgTimestamp = 0;
    private int fTimestamp;

    public static void incrementTimestamp() throws GNATbenchCoreException {
        if (!LibrarySemaphore.isProtected()) {
            throw new GNATbenchCoreException("Call is not protected.");
        }
        ++fgTimestamp;
    }

    private static int getTimestamp() throws GNATbenchCoreException {
        if (!LibrarySemaphore.isProtected()) {
            throw new GNATbenchCoreException("Call is not protected.");
        }
        return fgTimestamp;
    }

    public void checkTimestamp() throws GNATbenchCoreException {
        if (!LibrarySemaphore.isProtected()) {
            throw new GNATbenchCoreException("Call is not protected.");
        }
        if (this.fTimestamp != fgTimestamp) {
            throw new GNATbenchCoreException("GPR reference is older than the project registry.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GPRProject(Project_Type gpr, String name) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.fTimestamp = GPRProject.getTimestamp();
            this.fGPR = gpr;
            if (!name.equals("")) {
                try {
                    this.fEclipseProject = GPRProject.getEclipseProjectForGPRName(name);
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public IProject getProject() {
        return this.fEclipseProject;
    }

    public LinkedList getSourceDirectories(boolean recursive) throws GNATbenchCoreException {
        LinkedList<String> linkedList;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            LinkedList<String> result = new LinkedList<String>();
            String_List directories = this.fGPR.Source_Dirs(recursive, false);
            if (directories.Length() > 0) {
                int i = directories.First();
                while (i <= directories.Last()) {
                    result.add(directories.Get_Element_At(i).toString());
                    ++i;
                }
            }
            linkedList = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return linkedList;
    }

    public String[] getSourcesList(boolean recursive) throws GNATbenchCoreException {
        String[] stringArray;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            File_Array prjFiles = this.fGPR.Get_Source_Files(recursive);
            String[] result = new String[prjFiles.Length()];
            int fileInd = 0;
            int i = prjFiles.First();
            while (i <= prjFiles.Last()) {
                result[fileInd] = prjFiles.Get_Element_At(i).Full_Name(false).toString();
                ++fileInd;
                ++i;
            }
            VFS_Package.Unchecked_Free((File_Array.Ref)((File_Array.Ref)prjFiles.NewObjectRef()));
            stringArray = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return stringArray;
    }

    public LinkedList getObjectDirectories(boolean recursive) throws GNATbenchCoreException {
        LinkedList<String> linkedList;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            LinkedList<String> result = new LinkedList<String>();
            String directory = this.fGPR.Object_Path(recursive, false).toString();
            result.add(directory);
            linkedList = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return linkedList;
    }

    public File getFile() throws GNATbenchCoreException {
        File file;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            file = new File(this.getProject(), this.fGPR.Project_Path(new AdaString("")));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return file;
    }

    public String getName() throws GNATbenchCoreException {
        String string;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            string = this.fGPR.Project_Name_String().toString();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return string;
    }

    public ScenarioVariable[] getScenarioVariables() throws GNATbenchCoreException {
        ScenarioVariable[] scenarioVariableArray;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            scenarioVariableArray = this.fScenarioVariables;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return scenarioVariableArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadScenarioVariables() throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Scenario_Variable_Array vars = this.fGPR.Find_Scenario_Variables(true);
            ScenarioVariable[] variables = new ScenarioVariable[vars.Length()];
            int i = vars.First();
            block3: while (true) {
                block6: {
                    if (i <= vars.Last()) break block6;
                    this.fScenarioVariables = variables;
                    break;
                }
                String_List values = vars.Get_Element_At(i).Enum_Values_Of((Abstract_Registry)GNATbenchKernel.getDefault().getProjectRegistry());
                String[] possibleValues = new String[values.Length()];
                int j = values.First();
                while (true) {
                    if (j > values.Last()) {
                        variables[i - vars.First()] = new ScenarioVariable(this, vars.Get_Element_At(i).External_Reference_Of().toString(), vars.Get_Element_At(i).Value_Of().toString(), possibleValues);
                        ++i;
                        continue block3;
                    }
                    possibleValues[j - values.First()] = values.Get_Element_At(j).toString();
                    ++j;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public Project_Type[] getDependencies(boolean recursive) throws GNATbenchCoreException {
        Project_Type[] project_TypeArray;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Imported_Project_Iterator it = this.fGPR.Start(true, !recursive, true);
            int size = 0;
            while (!it.Current().equals((Object)Projects_Package.No_Project())) {
                ++size;
                it.Next();
            }
            it = this.fGPR.Start(true, !recursive, true);
            Project_Type[] result = new Project_Type[size];
            int i = 0;
            while (!it.Current().equals((Object)Projects_Package.No_Project())) {
                result[i] = it.Current();
                it.Next();
                ++i;
            }
            project_TypeArray = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return project_TypeArray;
    }

    public static GPRProject getGPRFor(IProject project) {
        String projectPath = GPRProject.getGPROSPath(project);
        if (projectPath != null && !projectPath.equals("")) {
            return GPRProject.getProjectFromPath(projectPath);
        }
        return null;
    }

    public static IProject getEclipseProjectForGPRPath(String gprName) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String propertyPath = GPRProject.getGPROSPath(projects[i]);
            if (gprName.equals(propertyPath)) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public static IProject getEclipseProjectForGPRName(String gprName) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String propertyPath = GPRProject.getGPROSPath(projects[i]);
            if (propertyPath != null && GPRProject.extractNameFromPath(gprName).toLowerCase().equals(GPRProject.extractNameFromPath(propertyPath).toLowerCase())) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public static GPRProject getProjectFromName(String name) {
        GPRProject gPRProject;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Project_Type prj = GNATbenchKernel.getDefault().getProjectRegistry().Get_Project_From_Name(Editor_Package.Get_String_Name_Id((AdaString)new AdaString(name)));
            gPRProject = new GPRProject(prj, name);
            Object var3_5 = null;
        }
        catch (GNATbenchCoreException e) {
            try {
                GNATbenchCorePlugin.getDefault().logError(null, e);
                Object var3_6 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return gPRProject;
    }

    public static GPRProject getProjectFromPath(String path) {
        GPRProject gPRProject;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Path parsedPath = new Path(path);
            String projectName = parsedPath.lastSegment();
            projectName = projectName.substring(0, projectName.length() - 4);
            projectName = projectName.replaceAll("-", ".");
            gPRProject = GPRProject.getProjectFromName(projectName);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return gPRProject;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDependency(String path) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            GPRProject removedProject = GPRProject.getProjectFromPath(path);
            Editor_Package.Remove_Imported_Project((Project_Type)this.fGPR, (Project_Type)removedProject.getGPRProject());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDependency(Project_Type project) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Editor_Package.Remove_Imported_Project((Project_Type)this.fGPR, (Project_Type)project);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public void addDependency(IProject project) throws GNATbenchCoreException {
        String path = GPRProject.getGPROSPath(project);
        if (path != null && !path.equals("") && GPRProject.isActive(project)) {
            this.addDependency(GPRProject.getGPROSPath(project));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDependency(String gprProjectPath) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Virtual_File projectLocation = VFS_Package.Create((AdaString)new AdaString(gprProjectPath));
            this.fGPRErrors.clear();
            Editor_Package.Add_Imported_Project_By_File((Project_Type)GNATbenchKernel.getDefault().getProjectRegistry().Get_Root_Project(), (Project_Type)GNATbenchKernel.getDefault().getProjectRegistry().Get_Root_Project(), (Virtual_File)projectLocation, (Output_Proc)new Output_Proc(){

                public void Output_Proc_Body(AdaString S) {
                    GPRProject.this.fGPRErrors.add(S.toString());
                }
            }, (boolean)false, (boolean)false);
            this.analyzeGPRErrors();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recompute() throws GNATbenchCoreException {
        GNATbenchKernel.getDefault().interruptConstructDatabaseLoad();
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            this.fGPRErrors.clear();
            GNATbenchKernel.getDefault().getProjectRegistry().Recompute_View(new Error_Report(){

                public void Error_Report_Body(AdaString Msg) {
                    GPRProject.this.fGPRErrors.add(Msg.toString());
                }
            });
            this.analyzeGPRErrors();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setGPRPath(IProject project, String path) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "gprName");
            try {
                project.setPersistentProperty(name, path);
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public static String getGPRPath(IProject project) {
        QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "gprName");
        try {
            return project.getPersistentProperty(name);
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return "";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setActive(IProject project, boolean active) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "isActive");
            try {
                project.setPersistentProperty(name, Boolean.valueOf(active).toString());
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public static boolean isActive(IProject project) {
        String prop;
        block3: {
            QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "isActive");
            try {
                prop = project.getPersistentProperty(name);
                if (prop != null) break block3;
                return true;
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
                return true;
            }
        }
        return Boolean.valueOf(prop);
    }

    public static String getGPROSPath(IProject project) {
        IFile file;
        String path;
        if (!project.isOpen()) {
            return "";
        }
        QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "gprName");
        try {
            path = project.getPersistentProperty(name);
            if (path == null) {
                return null;
            }
            file = project.getFile((IPath)new Path(path));
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return "";
        }
        if (file != null && file.exists()) {
            return file.getLocation().toOSString();
        }
        return path;
    }

    public static boolean isRootProject(IProject project) {
        QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "isRootProject");
        try {
            String prop = project.getPersistentProperty(name);
            return prop != null && prop.equals("TRUE");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void setRootProject(IProject project, boolean isRoot) {
        QualifiedName name = new QualifiedName(GNATbenchCorePlugin.getId(), "isRootProject");
        try {
            if (isRoot) {
                project.setPersistentProperty(name, "TRUE");
            } else {
                project.setPersistentProperty(name, "FALSE");
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
    }

    public static GPRProject getRoot() {
        GPRProject gPRProject;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            gPRProject = new GPRProject(GNATbenchKernel.getDefault().getProjectRegistry().Get_Root_Project(), "");
            Object var2_2 = null;
        }
        catch (GNATbenchCoreException e) {
            try {
                GNATbenchCorePlugin.getDefault().logError(null, e);
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return gPRProject;
    }

    public static String extractNameFromPath(String path) {
        Pattern namePattern = Pattern.compile("[\\\\/]?([a-zA-Z0-9_]+)\\.gpr$");
        Matcher matcher = namePattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return path;
    }

    public String[] getAttributeAsList(String attributeName, String packageName, String indexName) throws GNATbenchCoreException {
        String[] stringArray;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Argument_List list = this.fGPR.Get_Attribute_Value(Projects_Package.Build((AdaString)new AdaString(packageName), (AdaString)new AdaString(attributeName)), new AdaString(indexName));
            String[] result = new String[list.Last() - list.First() + 1];
            int i = list.First();
            while (i <= list.Last()) {
                result[i - list.First()] = list.Get_Element_At(i).toString();
                ++i;
            }
            stringArray = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return stringArray;
    }

    public String getAttributeValue(String attributeName, String packageName, String indexName) throws GNATbenchCoreException {
        Argument_List list;
        int semDepth;
        block3: {
            semDepth = LibrarySemaphore.startGPSWork();
            try {
                this.checkTimestamp();
                list = this.fGPR.Get_Attribute_Value(Projects_Package.Build((AdaString)new AdaString(packageName), (AdaString)new AdaString(attributeName)), new AdaString(indexName));
                if (list.Length() != 0) break block3;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return null;
        }
        String string = list.Get_Element_At(list.First()).toString();
        Object var6_7 = null;
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return string;
    }

    public Project_Type getGPRProject() throws GNATbenchCoreException {
        Project_Type project_Type;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            project_Type = this.fGPR;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return project_Type;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttributeValue(String attributeName, String packageName, String indexName, String value) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.checkTimestamp();
            Editor_Package.Update_Attribute_Value_In_Scenario((Project_Type)this.fGPR, (Scenario_Variable_Array)Projects_Package.No_Scenario(), (Attribute_Pkg)Projects_Package.Build((AdaString)new AdaString(packageName), (AdaString)new AdaString(attributeName)), (AdaString)new AdaString(value), (AdaString)new AdaString(indexName));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttributeValue(String attributeName, String packageName, String indexName, String[] values) throws GNATbenchCoreException {
        int semDepth;
        block7: {
            block6: {
                semDepth = LibrarySemaphore.startGPSWork();
                try {
                    this.checkTimestamp();
                    if (values.length == 0) {
                        Editor_Package.Delete_Attribute((Project_Type)this.fGPR, (Scenario_Variable_Array)Projects_Package.No_Scenario(), (Attribute_Pkg)Projects_Package.Build((AdaString)new AdaString(packageName), (AdaString)new AdaString(attributeName)), (AdaString)new AdaString(indexName));
                        Object var9_6 = null;
                        break block6;
                    }
                    Argument_List valuesList = new Argument_List(1, values.length);
                    int i = 0;
                    while (true) {
                        if (i >= values.length) {
                            Editor_Package.Update_Attribute_Value_In_Scenario((Project_Type)this.fGPR, (Scenario_Variable_Array)Projects_Package.No_Scenario(), (Attribute_Pkg)Projects_Package.Build((AdaString)new AdaString(packageName), (AdaString)new AdaString(attributeName)), (Argument_List)valuesList, (AdaString)new AdaString(indexName), (boolean)false);
                            break block7;
                        }
                        AdaString name = new AdaString(values[i]);
                        name.isOwned = false;
                        valuesList.Set_Element_At(i + 1, name);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return;
        }
        Object var9_8 = null;
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    private void analyzeGPRErrors() {
        final LinkedList messages = (LinkedList)this.fGPRErrors.clone();
        new Job("Update GPR Messages"){

            protected IStatus run(IProgressMonitor monitor) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(this, messages){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ LinkedList val$messages;
                    {
                        this.this$1 = var1_1;
                        this.val$messages = linkedList;
                    }

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            GPRProject.access$0(3.access$0(this.this$1), this.val$messages);
                        }
                        catch (GNATbenchCoreException gNATbenchCoreException) {}
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                catch (InterruptedException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                return GNATbenchCorePlugin.OK_STATUS;
            }

            static /* synthetic */ GPRProject access$0(3 var0) {
                return var0.GPRProject.this;
            }
        }.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeGPRErrorsInternal(LinkedList messages) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            try {
                Iterator iter;
                this.checkTimestamp();
                IMarker[] markers = this.fEclipseProject == null ? ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.adacore.gnatbench.core.GPRErrorMarker", false, 2) : this.fEclipseProject.findMarkers("com.adacore.gnatbench.core.GPRErrorMarker", false, 2);
                int i = 0;
                while (true) {
                    if (i >= markers.length) {
                        iter = messages.iterator();
                        break;
                    }
                    IProject prj = markers[i].getResource().getProject();
                    if (prj == null || !prj.hasNature(GNATbenchProjectNature.NATURE_ID)) {
                        markers[i].delete();
                    } else {
                        GPRProject gpr = GPRProject.getGPRFor(prj);
                        if (gpr != null && gpr.getGPRProject().View_Is_Complete()) {
                            markers[i].delete();
                        }
                    }
                    ++i;
                }
                while (iter.hasNext()) {
                    String[] parts;
                    String msg = (String)iter.next();
                    if (msg.indexOf("empty: Warning: there are no Ada source", 0) != -1 || (parts = (msg = msg.replaceAll("\n", "").replaceAll("\r", "")).split(":")).length < 2) continue;
                    GPRProject gpsPrj = GPRProject.getProjectFromName(parts[0]);
                    try {
                        IProject prj = gpsPrj.getProject();
                        IMarker marker = prj != null ? prj.createMarker("com.adacore.gnatbench.core.GPRErrorMarker") : ResourcesPlugin.getWorkspace().getRoot().createMarker("com.adacore.gnatbench.core.GPRErrorMarker");
                        marker.setAttribute("message", (Object)msg);
                        if (msg.toLowerCase().indexOf("warning") != -1) {
                            marker.setAttribute("severity", 1);
                            continue;
                        }
                        marker.setAttribute("severity", 2);
                    }
                    catch (CoreException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                }
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var10_15 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IFile file) throws GNATbenchCoreException {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            block6: {
                this.checkTimestamp();
                final StringBuffer buf = new StringBuffer();
                Registry_Package.Pretty_Print((Project_Type)this.fGPR, (int)3, (boolean)false, (Write_Char_Ap)new Write_Char_Ap(){

                    public void Write_Char_Ap_Body(char C) {
                        buf.append(C);
                    }
                }, (Write_Eol_Ap)new Write_Eol_Ap(){

                    public void Write_Eol_Ap_Body() {
                        buf.append("\n");
                    }
                }, (Write_Str_Ap)new Write_Str_Ap(){

                    public void Write_Str_Ap_Body(AdaString S) {
                        buf.append(S.toString());
                    }
                });
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(buf.toString().getBytes());
                    if (file.exists()) {
                        file.setContents((InputStream)input, 1, null);
                        break block6;
                    }
                    file.create((InputStream)input, true, null);
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError("", e);
                }
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    static /* synthetic */ void access$0(GPRProject gPRProject, LinkedList linkedList) throws GNATbenchCoreException {
        gPRProject.analyzeGPRErrorsInternal(linkedList);
    }
}

