/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.gpswrappers;

import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.library.Entities.Entities_Database;
import com.adacore.gnatbench.library.Entities.Entity_Information_Record;
import com.adacore.gnatbench.library.Entities.Entity_Reference;
import com.adacore.gnatbench.library.Entities.File_Location;
import com.adacore.gnatbench.library.Entities.Queries.Queries_Package;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.jni.AdaString;
import com.adacore.jni.IntegerRef;
import org.eclipse.core.resources.IProject;

public class Entity {
    private AdaLocation fSpec = null;
    private AdaLocation fBody = null;
    private IProject fProject = null;
    private boolean fIsValid = false;
    public String fName;
    public Entity_Information_Record fEntityInformation;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity(IProject project, String fileName, String name, int line, int column) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Virtual_File file = VFS_Package.Create_From_Base((AdaString)new AdaString(fileName));
            this.initialize(project, file, name, line, column);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity(AdaEntityReference reference) {
        this(reference.getLocation().getAdaFile().getProject(), reference.getLocation().getAdaFile().getOSPath(), reference.getName(), reference.getLocation().getGPSLine(), reference.getLocation().getGPSColumn());
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Virtual_File file = VFS_Package.Create((AdaString)new AdaString(reference.getLocation().getAdaFile().getOSPath()));
            this.initialize(reference.getLocation().getAdaFile().getProject(), file, reference.getName(), reference.getLocation().getGPSLine(), reference.getLocation().getGPSColumn());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity(IProject project, AdaConstruct construct) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Virtual_File file = VFS_Package.Create((AdaString)new AdaString(construct.getLocation().getAdaFile().getOSPath()));
            this.initialize(project, file, construct.getName(), construct.getLineEntity(), construct.getColumnEntity());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(IProject project, Virtual_File file, String name, int line, int column) {
        int semDepth;
        block8: {
            block7: {
                semDepth = LibrarySemaphore.startGPSWork();
                try {
                    this.fProject = project;
                    Entity_Information_Record.Ref entityRef = new Entity_Information_Record.Ref();
                    Entity_Reference closestRef = new Entity_Reference();
                    IntegerRef statusRef = new IntegerRef(0);
                    Queries_Package.Find_Declaration((Entities_Database)GNATbenchKernel.getDefault().getEntitiesDatabase(), (Virtual_File)file, (AdaString)new AdaString(name), (int)line, (int)column, (Entity_Information_Record.Ref)entityRef, (Entity_Reference)closestRef, (IntegerRef)statusRef, (boolean)false);
                    if (entityRef.ref == null) {
                        this.fIsValid = false;
                        Object var12_10 = null;
                        break block7;
                    }
                    this.fIsValid = true;
                    this.fEntityInformation = entityRef.ref;
                    this.fName = name;
                    File_Location specLoc = this.fEntityInformation.Get_Declaration_Of();
                    File_Location bodyLoc = new File_Location();
                    Queries_Package.Find_Next_Body((Entity_Information_Record)this.fEntityInformation, (File_Location)specLoc, (File_Location)bodyLoc, (boolean)false);
                    this.fSpec = AdaLocation.fromGPS(AdaFile.fromOSPath(this.fProject, specLoc.File().Get_Filename().Full_Name(false).toString()), specLoc.Line(), specLoc.Column());
                    if (bodyLoc.Column() != 0) {
                        this.fBody = AdaLocation.fromGPS(AdaFile.fromOSPath(this.fProject, bodyLoc.File().Get_Filename().Full_Name(false).toString()), bodyLoc.Line(), bodyLoc.Column());
                    }
                    if (this.fSpec != null) {
                        this.fSpec.setLength(this.fName.length());
                    }
                    if (this.fBody != null) {
                        this.fBody.setLength(this.fName.length());
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return;
        }
        Object var12_12 = null;
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public AdaLocation getSpec() {
        return this.fSpec;
    }

    public AdaLocation getBody() {
        return this.fBody;
    }

    public AdaLocation getBodyOrElseSpec() {
        if (this.fBody != null) {
            return this.fBody;
        }
        return this.fSpec;
    }

    public AdaLocation getSpecOrElseBody() {
        if (this.fSpec != null) {
            return this.fSpec;
        }
        return this.fBody;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isValid() {
        return this.fIsValid;
    }
}

