/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.builder;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.IGNATbenchProjectNatureContribution;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class GNATbenchProjectNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(GNATbenchCorePlugin.getId()) + ".GNATbenchProjectNature";
    private IProject fProject;

    public void configure() throws CoreException {
        GPRProject.setRootProject(this.fProject, true);
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(), "natureContribution");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return;
        }
        int extInd = 0;
        while (extInd < extensions.length) {
            IConfigurationElement[] elements = extensions[extInd].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("contribution")) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[extInd].getNamespace());
                        IGNATbenchProjectNatureContribution contrib = (IGNATbenchProjectNatureContribution)bundle.loadClass(elements[i].getAttribute("class")).newInstance();
                        contrib.configure(this.fProject);
                    }
                    catch (InvalidRegistryObjectException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (InstantiationException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (IllegalAccessException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (ClassNotFoundException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                }
                ++i;
            }
            ++extInd;
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public static void addNature(IProject project) throws CoreException {
        if (!project.hasNature(NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = NATURE_ID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }
}

