/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.builder;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.make.MakefileTarget;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class GNATbenchIncrementalBuilder
extends IncrementalProjectBuilder {
    public static final String AUTO_BUILD_TARGET = "autobuild";
    public static final String ANALYZE_TARGET = "analyze";
    public static final String FULL_BUILD_TARGET = "build";
    public static final String CLEAN_TARGET = "clean";
    public static final String REBUILD_TARGET = "rebuild";
    public static final String BUILDER_ID = String.valueOf(GNATbenchCorePlugin.getId()) + ".GNATbenchBuilder";
    private boolean sourceFilesChanged = false;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.invokeMakefile(FULL_BUILD_TARGET);
        } else if (kind == 10 || kind == 9) {
            this.sourceFilesChanged = false;
            IResourceDelta rootDelta = this.getDelta(this.getProject());
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IFile file;
                    if (delta.getKind() != 4) {
                        return true;
                    }
                    if ((delta.getFlags() & 0x100) == 0) {
                        return true;
                    }
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && ((file = (IFile)resource).getFileExtension().equalsIgnoreCase("adb") || file.getFileExtension().equalsIgnoreCase("ads")) && !resource.getName().startsWith("b~")) {
                        GNATbenchIncrementalBuilder.this.sourceFilesChanged = true;
                    }
                    return true;
                }
            };
            try {
                rootDelta.accept(visitor);
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
                return null;
            }
            if (this.sourceFilesChanged) {
                this.invokeMakefile(AUTO_BUILD_TARGET);
            }
        }
        return null;
    }

    protected void invokeMakefile(String target) {
        IProject project = this.getProject();
        new MakefileTarget(project, target, null).invoke(null);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        this.invokeMakefile(CLEAN_TARGET);
    }

    public static String makefileFromBuilder(String builderName) {
        String buildCommand = String.valueOf(builderName) + " -P " + "\"$(GPRPATH)\"";
        String autoBuildCommand = String.valueOf(builderName) + " -gnatc -c -k " + " -P " + "\"$(GPRPATH)\"";
        String analyzeCommand = String.valueOf(builderName) + " -f " + " -gnatc -c -k " + " -P " + "\"$(GPRPATH)\"";
        int makePos = builderName.lastIndexOf("make");
        String cleanCommand = builderName.subSequence(0, makePos) + "clean -P " + "\"$(GPRPATH)\"";
        String makeFile = "# This is an automatically-generated makefile, but you\n# may edit it as long as you keep these original target\n# names defined.\n\n" + GNATbenchIncrementalBuilder.makefileFromStrings(buildCommand, cleanCommand, analyzeCommand, autoBuildCommand);
        return makeFile;
    }

    public static String makefileFromStrings(String buildCommand, String cleanCommand, String analyzeCommand, String autoBuildCommand) {
        String makeFile = "# Not intended for manual invocation.\n# Invoked if automatic builds are enabled.\n# Analyzes only on those sources that have changed.\n# Does not build executables.\nautobuild:\n\t" + autoBuildCommand + "\n\n" + "# Clean a project of all build products.\n" + CLEAN_TARGET + ":\n" + "\t" + cleanCommand + "\n\n" + "# Check *all* sources for errors, even those not changed.\n" + "# Does not build executables.\n" + ANALYZE_TARGET + ":\n" + "\t" + analyzeCommand + "\n\n" + "# Build executables for all mains defined by the project.\n" + FULL_BUILD_TARGET + ":\n" + "\t" + buildCommand + "\n\n" + "# Clean, then build executables for all mains defined by the project.\n" + REBUILD_TARGET + ": " + CLEAN_TARGET + " " + FULL_BUILD_TARGET + "\n";
        return makeFile;
    }

    public static class JobCompleteAdapter
    extends JobChangeAdapter {
        IProject project;

        public JobCompleteAdapter(IProject project) {
            this.project = project;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                    return;
                }
            }
        }
    }
}

