/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.builder;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.builder.BuildConsole;
import com.adacore.gnatbench.core.builder.BuildConsoleManager;
import com.adacore.gnatbench.core.builder.IGNATbenchBuildListener;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.gpswrappers.ScenarioVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class GNATbenchBuilderJob
extends WorkspaceJob {
    String command;
    IProject project;
    BuildConsole console;

    public GNATbenchBuilderJob(String command, IProject project) {
        super("Ada build [" + project.getName() + "]");
        this.project = project;
        this.command = command;
        this.console = BuildConsoleManager.findConsole("Ada build [" + project.getName() + "]");
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        Process proc;
        String[] env;
        File workingDir = this.project.getLocation().toFile();
        try {
            env = this.environment(this.project, monitor);
        }
        catch (Throwable throwable) {
            return new Status(4, GNATbenchCorePlugin.getId(), 0, "Could not get environment for command '" + this.command + "'", null);
        }
        this.console.clearConsole();
        try {
            proc = Runtime.getRuntime().exec(this.command, env, workingDir);
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return new Status(4, GNATbenchCorePlugin.getId(), 0, "Could not execute command '" + this.command + "'", null);
        }
        ConsolePrinter errorMessages = new ConsolePrinter(proc.getErrorStream());
        ConsolePrinter normalMessages = new ConsolePrinter(proc.getInputStream());
        errorMessages.start();
        normalMessages.start();
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return new Status(4, GNATbenchCorePlugin.getId(), 0, "Could not await process completion", null);
        }
        this.printCompletionMsg();
        this.signalCompilationCompleted(this.project, this.compiledFiles(this.project, monitor), errorMessages.getMessages(), monitor);
        return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
    }

    protected String[] environment(IProject project, IProgressMonitor monitor) throws GNATbenchCoreException {
        String[] result = null;
        Map allVars = null;
        try {
            allVars = this.systemEnvVars();
        }
        catch (Throwable e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return null;
        }
        GPRProject gprProject = GPRProject.getGPRFor(project);
        gprProject.loadScenarioVariables();
        ScenarioVariable[] scenarioVars = gprProject.getScenarioVariables();
        int k = 0;
        while (k < scenarioVars.length) {
            allVars.put(scenarioVars[k].getName(), scenarioVars[k].getValue());
            ++k;
        }
        int mapsize = allVars.size();
        if (mapsize != 0) {
            result = new String[mapsize];
        }
        Iterator keyValuePairs1 = allVars.entrySet().iterator();
        int k2 = 0;
        while (k2 < mapsize) {
            Map.Entry entry = keyValuePairs1.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            result[k2] = String.valueOf((String)key) + "=" + (String)value;
            ++k2;
        }
        return result;
    }

    protected Map systemEnvVars() throws Throwable {
        String line;
        Process proc = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String OS = System.getProperty("os.name").toLowerCase();
        String command = this.isWindows95(OS) ? "command.com /c set" : (this.isWindowsNTcompatible(OS) ? "cmd.exe /c set" : "env");
        proc = Runtime.getRuntime().exec(command);
        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            result.put(key, value);
        }
        return result;
    }

    protected AdaFile[] compiledFiles(IProject project, IProgressMonitor monitor) {
        String[] sources;
        try {
            GPRProject gprProject = GPRProject.getGPRFor(project);
            sources = gprProject.getSourcesList(true);
        }
        catch (Exception exception) {
            return null;
        }
        AdaFile[] result = new AdaFile[sources.length];
        int i = 0;
        while (i < sources.length) {
            result[i] = AdaFile.fromOSPath(null, sources[i]);
            ++i;
        }
        return result;
    }

    protected void signalCompilationCompleted(IProject project, AdaFile[] compiledFiles, String[] errors, IProgressMonitor monitor) {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(), "buildListener");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return;
        }
        int extInd = 0;
        while (extInd < extensions.length) {
            IConfigurationElement[] elements = extensions[extInd].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("listener")) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[extInd].getNamespace());
                        IGNATbenchBuildListener builderListener = (IGNATbenchBuildListener)bundle.loadClass(elements[i].getAttribute("class")).newInstance();
                        builderListener.compilationCompleted(project, compiledFiles, errors, monitor);
                    }
                    catch (InvalidRegistryObjectException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (InstantiationException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (IllegalAccessException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    catch (ClassNotFoundException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                }
                ++i;
            }
            ++extInd;
        }
    }

    protected boolean isWindowsNTcompatible(String OS) {
        if (OS.indexOf("nt") > -1) {
            return true;
        }
        if (OS.indexOf("windows 2000") > -1) {
            return true;
        }
        return OS.indexOf("windows xp") > -1;
    }

    protected boolean isWindows95(String OS) {
        return OS.indexOf("windows 9") > -1;
    }

    protected void printCompletionMsg() {
        DateFormat df = DateFormat.getDateTimeInstance(2, 0);
        String now = df.format(new Date());
        this.console.print("Ada builder for [" + this.project.getName() + "] completed " + now + ".");
    }

    class ConsolePrinter
    extends Thread {
        InputStream is;
        ArrayList rawMessages = new ArrayList();

        ConsolePrinter(InputStream is) {
            this.is = is;
        }

        public String[] getMessages() {
            if (this.rawMessages.isEmpty()) {
                String[] result = new String[]{""};
                return result;
            }
            this.rawMessages.trimToSize();
            String[] result = new String[this.rawMessages.size()];
            int index = 0;
            Iterator iter = this.rawMessages.iterator();
            while (iter.hasNext()) {
                String element;
                result[index] = element = (String)iter.next();
                ++index;
            }
            return result;
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    GNATbenchBuilderJob.this.console.print(String.valueOf(line) + "\n");
                    this.rawMessages.add(line);
                }
            }
            catch (IOException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
            }
        }
    }
}

