/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.IAdaConstructIconProvider;
import com.adacore.gnatbench.library.Language.Simple_Construct_Information;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.jni.AdaString;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class AdaSimpleConstruct {
    protected int fOffsetBegin;
    protected int fOffsetEntity;
    protected int fOffsetEnd;
    protected int fLineBegin;
    protected int fLineEntity;
    protected int fLineEnd;
    protected int fColumnBegin;
    protected int fColumnEntity;
    protected int fColumnEnd;
    protected String fName;
    protected int fCategory;
    protected AdaLocation fLocation;
    protected AdaConstruct fParent;
    protected int fVisibility;
    protected boolean fIsDeclaration;
    protected Image fImage = null;
    private LinkedList fAdapters = new LinkedList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdaSimpleConstruct(Simple_Construct_Information content, AdaFile file) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.fOffsetBegin = content.Sloc_Start().Index() - 1;
            this.fOffsetEntity = content.Sloc_Entity().Index() - 1;
            this.fOffsetEnd = content.Sloc_End().Index() - 1;
            this.fLineBegin = content.Sloc_Start().Line() - 1;
            this.fLineEntity = content.Sloc_Entity().Line() - 1;
            this.fLineEnd = content.Sloc_End().Line() - 1;
            this.fColumnBegin = content.Sloc_Start().Column() - 1;
            this.fColumnEntity = content.Sloc_Entity().Column() - 1;
            this.fColumnEnd = content.Sloc_End().Column() - 1;
            AdaString name = content.Name();
            this.fName = name != null ? content.Name().toString() : "";
            this.fCategory = content.Category();
            this.fVisibility = content.Visibility();
            this.fIsDeclaration = content.Is_Declaration();
            this.fLocation = AdaLocation.fromEclipse(file, this.fLineEntity, this.fColumnEntity);
            this.fLocation.setLength(this.fName.length());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AdaSimpleConstruct)) {
            return false;
        }
        AdaSimpleConstruct construct = (AdaSimpleConstruct)o;
        return construct.fLocation.equals(this.fLocation);
    }

    public AdaLocation getLocation() {
        return this.fLocation;
    }

    public Image getImage() {
        if (this.fImage == null) {
            this.fImage = this.getImageFromExtension();
        }
        return this.fImage;
    }

    private Image getImageFromExtension() {
        return AdaSimpleConstruct.getIconProvider().getImage(this);
    }

    public static Image getImage(int category, int visibility) {
        return AdaSimpleConstruct.getIconProvider().getImage(category, visibility);
    }

    private static IAdaConstructIconProvider getIconProvider() {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(), "constructIcon");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IExtension relevantExtension = extensions[extensions.length - 1];
        IConfigurationElement[] elements = relevantExtension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("provider")) {
                try {
                    Bundle bundle = Platform.getBundle((String)relevantExtension.getNamespace());
                    IAdaConstructIconProvider iconProvider = (IAdaConstructIconProvider)bundle.loadClass(elements[i].getAttribute("class")).newInstance();
                    return iconProvider;
                }
                catch (InvalidRegistryObjectException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                catch (InstantiationException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                catch (IllegalAccessException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                catch (ClassNotFoundException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
            }
            ++i;
        }
        return null;
    }

    public void setAdapter(Object adapter) {
        this.fAdapters.add(adapter);
    }

    public Object getAdapter(Class adapterClass) {
        Iterator iter = this.fAdapters.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!element.getClass().isAssignableFrom(adapterClass)) continue;
            return element;
        }
        return null;
    }

    public int getCategory() {
        return this.fCategory;
    }

    public int getOffsetBegin() {
        return this.fOffsetBegin;
    }

    public int getOffsetEntity() {
        return this.fOffsetEntity;
    }

    public int getOffsetEnd() {
        return this.fOffsetEnd;
    }

    public int getLineBegin() {
        return this.fLineBegin;
    }

    public int getLineEntity() {
        return this.fLineEntity;
    }

    public int getLineEnd() {
        return this.fLineEnd;
    }

    public int getColumnBegin() {
        return this.fColumnBegin;
    }

    public int getColumnEntity() {
        return this.fColumnEntity;
    }

    public int getColumnEnd() {
        return this.fColumnEnd;
    }

    public String getName() {
        return this.fName;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public String toString() {
        return this.fName;
    }
}

