/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.gpswrappers.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AdaLocation {
    private static Pattern fgLocationPattern = Pattern.compile("(?:(?:[^:]+):)??((?:[A-Za-z]:\\\\)?[^:]+):([0-9]+):([0-9]+)");
    private AdaFile fFile;
    private int fLine;
    private int fColumn;
    private int fLength = 0;

    public static AdaLocation fromGPS(AdaFile file, int line, int column) {
        return new AdaLocation(file, line - 1, column - 1);
    }

    public static AdaLocation fromEclipse(AdaFile file, int line, int column) {
        return new AdaLocation(file, line, column);
    }

    private AdaLocation(AdaFile file, int line, int column) {
        this.fFile = file;
        this.fLine = line;
        this.fColumn = column;
    }

    public AdaFile getAdaFile() {
        return this.fFile;
    }

    public int getGPSLine() {
        return this.fLine + 1;
    }

    public int getGPSColumn() {
        return this.fColumn + 1;
    }

    public int getEclipseLine() {
        return this.fLine;
    }

    public int getEclipseColumn() {
        return this.fColumn;
    }

    public String toString() {
        return String.valueOf(this.fFile.getEclipsePath()) + ":" + this.fLine + ":" + this.fColumn;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public static AdaLocation parseLocation(String location, IProject project, boolean isGPSFileName) {
        Matcher matchesEntity = fgLocationPattern.matcher(location);
        if (!matchesEntity.find()) {
            return null;
        }
        String filePath = matchesEntity.group(1).replaceAll("////////", "////");
        AdaFile adaFile = AdaFile.fromOSPath(project, filePath);
        if (isGPSFileName) {
            File file = new File(project, (IPath)new Path(matchesEntity.group(1)));
            adaFile = AdaFile.fromOSPath(project, file.getPath());
        }
        AdaLocation result = AdaLocation.fromGPS(adaFile, Integer.parseInt(matchesEntity.group(2)), Integer.parseInt(matchesEntity.group(3)));
        return result;
    }

    public boolean equals(Object cmp) {
        if (!(cmp instanceof AdaLocation)) {
            return false;
        }
        AdaLocation loc = (AdaLocation)cmp;
        return loc.fColumn == this.fColumn && loc.fLine == this.fLine && loc.fFile.getEclipsePath().equals(this.fFile.getEclipsePath());
    }
}

