/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AdaFile {
    private String fFullPath = null;
    private IFile fFile = null;
    private IProject fProject = null;

    public static AdaFile fromOSPath(IProject project, String path) {
        IFile linkedFile;
        AdaFile adaFile = null;
        if (project != null && (linkedFile = AdaFile.getLinkedResourceFor(project, path)) != null) {
            adaFile = new AdaFile(linkedFile);
        }
        if (adaFile == null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                linkedFile = AdaFile.getLinkedResourceFor(projects[i], path);
                if (linkedFile != null) {
                    adaFile = new AdaFile(linkedFile);
                    break;
                }
                ++i;
            }
        }
        if (adaFile == null) {
            adaFile = new AdaFile(path);
        }
        if (adaFile.fProject == null) {
            adaFile.fProject = project;
        }
        return adaFile;
    }

    public static AdaFile fromEclipsePath(String path) {
        return new AdaFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)));
    }

    private AdaFile(String fullPath) {
        this.fFullPath = fullPath;
    }

    public AdaFile(IFile file) {
        this.fFile = file;
        this.fProject = file.getProject();
    }

    public IFile getFile() {
        if (this.fFile != null) {
            return this.fFile;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.fFullPath));
    }

    public String getOSPath() {
        if (this.fFullPath != null) {
            return this.fFullPath;
        }
        return this.fFile.getLocation().toOSString();
    }

    public String getEclipsePath() {
        IFile file = this.getFile();
        if (file != null) {
            return file.getFullPath().toString();
        }
        return this.fFullPath;
    }

    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            return null;
        }
        return file.getProject();
    }

    private static IFile getLinkedResourceFor(IProject project, String path) {
        IResource[] resources = null;
        Path sourcePath = new Path(path);
        try {
            resources = project.members();
        }
        catch (CoreException coreException) {
            return null;
        }
        int i = 0;
        while (i < resources.length) {
            IPath folderPath;
            IFolder folder;
            if (resources[i] instanceof IFolder && (folder = (IFolder)resources[i]).isLinked() && sourcePath.matchingFirstSegments(folderPath = folder.getLocation()) == folderPath.segmentCount()) {
                return folder.getFile(sourcePath.removeFirstSegments(folderPath.segmentCount()));
            }
            ++i;
        }
        return null;
    }
}

