/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.utils.SyntaxUtils;

public class AdaEntityReference {
    private String fName;
    private AdaLocation fLocation;
    private int fOffset;
    private AdaDocumentBuffer fBuffer;

    public AdaEntityReference(AdaDocumentBuffer buffer, AdaLocation location, int offset) {
        this.fBuffer = buffer;
        this.fName = buffer.getContent(location);
        this.fLocation = location;
        this.fOffset = offset;
    }

    public AdaEntityReference(AdaDocumentBuffer buffer, AdaConstruct construct) {
        this.fBuffer = buffer;
        this.fName = construct.getName();
        this.fLocation = construct.getLocation();
        this.fOffset = this.fBuffer.getOffset(this.fLocation);
    }

    public String getName() {
        return this.fName;
    }

    public AdaLocation getLocation() {
        return this.fLocation;
    }

    public boolean isRegularIdentifier() {
        if (this.fName.length() == 0) {
            return false;
        }
        if (!(this.fName.charAt(0) >= 'A' && this.fName.charAt(0) <= 'Z' || this.fName.charAt(0) >= 'a' && this.fName.charAt(0) <= 'z')) {
            return false;
        }
        int i = 0;
        while (i < SyntaxUtils.fgAdaKeywords.length) {
            if (SyntaxUtils.fgAdaKeywords[i].equals(this.fName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getOffset() {
        return this.fOffset;
    }
}

