/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.AdaSimpleConstruct;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.library.Language.Construct_Information;
import com.adacore.gnatbench.library.Language.Simple_Construct_Information;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.jni.AdaString;
import java.util.Iterator;
import java.util.LinkedList;

public class AdaConstruct
extends AdaSimpleConstruct {
    private LinkedList fChildren = new LinkedList();
    private String fProfile;
    private String fOriginalText;
    private AdaConstruct fPart1 = null;
    private AdaConstruct fPart2 = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AdaConstruct(Construct_Information content, AdaDocumentBuffer buffer) {
        super(AdaConstruct.toSimpleConstructInformation(content), buffer.getBaseLocation().getAdaFile());
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            AdaString prof = content.Profile();
            this.fProfile = prof != null ? prof.toString() : new String("");
            this.fIsDeclaration = content.Is_Declaration();
            this.fLocation = AdaLocation.fromEclipse(buffer.getBaseLocation().getAdaFile(), this.fLineEntity, this.fColumnEntity);
            this.fLocation.setLength(this.fName.length());
            this.fOriginalText = buffer.toString();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public boolean include(AdaConstruct node) {
        return this.fOffsetBegin <= node.fOffsetBegin && this.fOffsetEnd >= node.fOffsetEnd;
    }

    public boolean include(AdaLocation location) {
        return this.fLineBegin <= location.getEclipseLine() && this.fLineEnd >= location.getEclipseLine();
    }

    public void add(AdaConstruct node) {
        this.fChildren.add(node);
        node.fParent = this;
    }

    public boolean hasChildren(IAdaConstructFilterProvider filter) {
        if (filter == null) {
            return this.fChildren.size() > 0;
        }
        return this.getChildren(filter).length > 0;
    }

    public AdaConstruct[] getChildren(IAdaConstructFilterProvider constructFilter) {
        if (constructFilter == null) {
            AdaConstruct[] children = new AdaConstruct[this.fChildren.size()];
            int index = 0;
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                AdaConstruct element;
                children[index] = element = (AdaConstruct)iter.next();
                ++index;
            }
            return children;
        }
        Object[] childrenObj = this.getChildrenList(constructFilter).toArray();
        AdaConstruct[] children = new AdaConstruct[childrenObj.length];
        int i = 0;
        while (i < childrenObj.length) {
            children[i] = (AdaConstruct)childrenObj[i];
            ++i;
        }
        return children;
    }

    public LinkedList getChildrenList(IAdaConstructFilterProvider constructFilter) {
        if (constructFilter == null) {
            return this.fChildren;
        }
        return constructFilter.getFilter().getFilteredChildren(this.fChildren);
    }

    private void addOnlyMains(LinkedList destination, LinkedList source) {
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            AdaConstruct element = (AdaConstruct)iter.next();
            if (!element.isMainConstruct()) continue;
            destination.add(element);
        }
    }

    public AdaConstruct[] getAllMainChildren(IAdaConstructFilterProvider constructFilter) {
        LinkedList allChildren = new LinkedList();
        this.addOnlyMains(allChildren, this.getChildrenList(constructFilter));
        AdaConstructFilter filter = constructFilter.getFilter();
        if (this.fPart1 != null && filter.passFilter(this.fPart1)) {
            this.addOnlyMains(allChildren, this.fPart1.getChildrenList(constructFilter));
        }
        if (this.fPart2 != null && filter.passFilter(this.fPart2)) {
            this.addOnlyMains(allChildren, this.fPart2.getChildrenList(constructFilter));
        }
        AdaConstruct[] allChildrenArray = new AdaConstruct[allChildren.size()];
        int index = 0;
        Iterator iter = allChildren.iterator();
        while (iter.hasNext()) {
            AdaConstruct element;
            allChildrenArray[index] = element = (AdaConstruct)iter.next();
            ++index;
        }
        return allChildrenArray;
    }

    public void setChildren(AdaConstruct[] children) {
        this.fChildren.clear();
        int i = 0;
        while (i < children.length) {
            children[i].fParent = this;
            this.fChildren.add(children[i]);
            ++i;
        }
    }

    public AdaConstruct getParent(IAdaConstructFilterProvider constructFilter) {
        if (this.fParent == null) {
            return null;
        }
        if (constructFilter == null) {
            return this.fParent;
        }
        if (constructFilter.getFilter().simpleFilter(this.fParent)) {
            return this.fParent;
        }
        return this.fParent.getParent(constructFilter);
    }

    public AdaConstruct getMainParent(IAdaConstructFilterProvider constructFilter) {
        if (this.fParent == null) {
            return null;
        }
        AdaConstruct mainParent = this.fParent.getMainConstruct();
        if (constructFilter == null) {
            return mainParent;
        }
        if (constructFilter.getFilter().simpleFilter(mainParent)) {
            return mainParent;
        }
        return mainParent.getMainParent(constructFilter);
    }

    public String toString() {
        if (this.fCategory >= 3 && this.fCategory <= 8 || this.fCategory == 10) {
            return String.valueOf(this.fName) + " " + this.getProfile();
        }
        return this.fName;
    }

    public void invert() {
        LinkedList newList = new LinkedList();
        int i = this.fChildren.size() - 1;
        while (i >= 0) {
            newList.add(this.fChildren.get(i));
            --i;
        }
        this.fChildren = newList;
    }

    public boolean needsAdaptation(AdaConstruct construct) {
        return construct.fOffsetBegin != this.fOffsetBegin || construct.fOffsetEnd != this.fOffsetEnd || construct.fOffsetEntity != this.fOffsetEntity || !this.fProfile.equals(construct.fProfile) || this.fVisibility != construct.fVisibility || this.fCategory != construct.fCategory;
    }

    public void adapt(AdaConstruct e) {
        this.fOffsetBegin = e.fOffsetBegin;
        this.fOffsetEntity = e.fOffsetEntity;
        this.fOffsetEnd = e.fOffsetEnd;
        this.fLineBegin = e.fLineBegin;
        this.fLineEntity = e.fLineEntity;
        this.fLineEnd = e.fLineEnd;
        this.fColumnBegin = e.fColumnBegin;
        this.fColumnEntity = e.fColumnEntity;
        this.fColumnEnd = e.fColumnEnd;
        this.fProfile = e.fProfile;
        this.fVisibility = e.fVisibility;
        this.fCategory = e.fCategory;
        this.fOriginalText = e.fOriginalText;
        this.fImage = null;
    }

    public String getFilePath() {
        return this.fLocation.getAdaFile().getOSPath();
    }

    public boolean isParent(AdaConstruct construct) {
        AdaConstruct current = construct;
        while (current != null) {
            if (current == this) {
                return true;
            }
            current = current.fParent;
        }
        return false;
    }

    public String getProfile() {
        return this.fProfile.replaceAll("[\n\r]", "").replaceAll("[ ]+", " ");
    }

    public void printTree(IAdaConstructFilterProvider constructFilter) {
        AdaConstruct[] children = this.getChildren(constructFilter);
        System.out.println(this);
        int i = 0;
        while (i < children.length) {
            children[i].printTree(constructFilter);
            ++i;
        }
    }

    public void groupChildren() {
        Object[] elements = this.fChildren.toArray();
        int i = 0;
        while (i < elements.length) {
            AdaConstruct construct = (AdaConstruct)elements[i];
            construct.fPart1 = null;
            construct.fPart2 = null;
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            AdaConstruct construct1 = (AdaConstruct)elements[i];
            if (construct1.fCategory >= 1 && construct1.fCategory <= 19) {
                construct1.groupChildren();
                int j = i + 1;
                while (j < elements.length) {
                    AdaConstruct construct2 = (AdaConstruct)elements[j];
                    if (construct2.fCategory >= 1 && construct2.fCategory <= 19 && construct1.fName.toLowerCase().equals(construct2.fName.toLowerCase())) {
                        if (construct1.fCategory >= 11 && construct1.fCategory <= 19) {
                            construct1.linkParts(construct2);
                        } else if (construct1.fCategory == construct2.fCategory && construct1.getProfile().replaceAll(" ", "").toLowerCase().equals(construct2.getProfile().replaceAll(" ", "").toLowerCase()) && !construct1.isGenericInstanciation() && !construct2.isGenericInstanciation()) {
                            construct1.linkParts(construct2);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isGenericInstanciation() {
        i = this.fOffsetEntity;
        while (i < this.fOriginalText.length()) {
            if (Character.isWhitespace(this.fOriginalText.charAt(i))) break;
            ++i;
        }
        while (i < this.fOriginalText.length()) {
            if (!Character.isWhitespace(this.fOriginalText.charAt(i))) break;
            ++i;
        }
        i += this.fProfile.length();
        while (i < this.fOriginalText.length()) {
            if (!Character.isWhitespace(this.fOriginalText.charAt(i))) break;
            ++i;
        }
        if (i < this.fOriginalText.length() && this.fOriginalText.charAt(i) != ';') ** GOTO lbl19
        return false;
        while (Character.isLetterOrDigit(this.fOriginalText.charAt(i))) {
            ++i;
lbl19:
            // 2 sources

            if (i < this.fOriginalText.length()) continue;
        }
        while (i < this.fOriginalText.length()) {
            if (!Character.isWhitespace(this.fOriginalText.charAt(i))) break;
            ++i;
        }
        if (i + 3 >= this.fOriginalText.length()) {
            return false;
        }
        if (!(this.fOriginalText.charAt(i) != 'n' && this.fOriginalText.charAt(i) != 'N' || this.fOriginalText.charAt(i + 1) != 'e' && this.fOriginalText.charAt(i + 1) != 'E' || this.fOriginalText.charAt(i + 2) != 'w' && this.fOriginalText.charAt(i + 2) != 'W')) {
            if (i + 3 >= this.fOriginalText.length()) {
                return true;
            }
            if (Character.isWhitespace(this.fOriginalText.charAt(i + 3))) {
                return true;
            }
        }
        return false;
    }

    private void linkParts(AdaConstruct construct) {
        if (this.fPart1 == null) {
            this.fPart1 = construct;
        } else {
            this.fPart2 = construct;
        }
        if (construct.fPart1 == null) {
            construct.fPart1 = this;
        } else {
            construct.fPart2 = this;
        }
    }

    public boolean isBefore(AdaConstruct construct) {
        if (this.fLineBegin < construct.fLineBegin) {
            return true;
        }
        return this.fLineBegin == construct.fLineBegin && this.fColumnBegin < construct.fColumnBegin;
    }

    public boolean isMainConstruct() {
        if (this.fPart1 != null && !this.isBefore(this.fPart1)) {
            return false;
        }
        return this.fPart2 == null || this.isBefore(this.fPart2);
    }

    public AdaConstruct getMainConstruct() {
        if (this.isMainConstruct()) {
            return this;
        }
        if (this.fPart1.isMainConstruct()) {
            return this.fPart1;
        }
        return this.fPart2;
    }

    public AdaConstruct getNextPart() {
        if (this.fPart1 == null) {
            return this;
        }
        if (this.fPart2 != null) {
            if (this.isBefore(this.fPart1)) {
                return this.fPart1;
            }
            if (this.isBefore(this.fPart2)) {
                return this.fPart2;
            }
        }
        return this.fPart1;
    }

    public int getNbParts() {
        if (this.fPart1 == null) {
            return 0;
        }
        if (this.fPart2 == null) {
            return 1;
        }
        return 2;
    }

    public AdaConstruct getPart1() {
        return this.fPart1;
    }

    public AdaConstruct getPart2() {
        return this.fPart2;
    }

    public boolean getIsDeclaration() {
        return this.fIsDeclaration;
    }

    private static Simple_Construct_Information toSimpleConstructInformation(Construct_Information content) {
        Simple_Construct_Information simple_Construct_Information;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Simple_Construct_Information simple = new Simple_Construct_Information();
            content.To_Simple_Construct_Information(simple, true);
            simple_Construct_Information = simple;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return simple_Construct_Information;
    }
}

