/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.analyzer;

import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaConstructFilter;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.analyzer.IAdaAnalyzerListener;
import com.adacore.gnatbench.core.analyzer.IAdaConstructFilterProvider;
import com.adacore.gnatbench.library.Language.Ada.Ada_Package;
import com.adacore.gnatbench.library.Language.Construct_Information;
import com.adacore.gnatbench.library.Language.Construct_List;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.jni.AdaString;
import java.util.Iterator;
import java.util.LinkedList;

public class AdaAnalyzer {
    private AdaDocumentBuffer fBuffer = null;
    private AdaConstruct[] fData = new AdaConstruct[0];
    private LinkedList fListeners = new LinkedList();
    private LinkedList fElementsModified = new LinkedList();

    public void setDocumentBuffer(AdaDocumentBuffer buffer) {
        this.fBuffer = buffer;
    }

    public void addAdaAnalyzerListener(IAdaAnalyzerListener listener) {
        this.fListeners.add(listener);
    }

    public void removeAdaAnalyzerListener(IAdaAnalyzerListener listener) {
        this.fListeners.remove(listener);
    }

    public void fireElementsModifs() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IAdaAnalyzerListener listener = (IAdaAnalyzerListener)iter.next();
            AdaConstructFilter filter = listener.getFilter();
            filter.initialize();
            Iterator iter2 = this.fElementsModified.iterator();
            while (iter2.hasNext()) {
                Operation operation = (Operation)iter2.next();
                AdaConstruct construct = operation.fConstruct;
                if (!filter.passFilter(construct)) continue;
                switch (operation.fOp) {
                    case 0: {
                        listener.elementAdded(construct);
                        break;
                    }
                    case 1: {
                        listener.elementRemoved(construct);
                        break;
                    }
                    case 2: {
                        listener.elementModified(construct);
                    }
                }
            }
        }
        this.fElementsModified.clear();
    }

    public AdaConstruct[] analyze() {
        AdaConstruct[] adaConstructArray;
        ElementStack stack;
        Construct_List list;
        int semDepth;
        block7: {
            block6: {
                semDepth = LibrarySemaphore.startGPSWork();
                if (this.fBuffer != null) break block6;
                AdaConstruct[] adaConstructArray2 = new AdaConstruct[]{};
                Object var6_5 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                return adaConstructArray2;
            }
            list = new Construct_List();
            Ada_Package.Ada_Lang().Parse_Constructs(new AdaString(this.fBuffer.getContent()), list);
            stack = new ElementStack();
            if (list != null) break block7;
            this.fData = new AdaConstruct[0];
            AdaConstruct[] adaConstructArray3 = this.fData;
            Object var6_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            return adaConstructArray3;
        }
        try {
            Construct_Information current = list.First();
            while (current != null) {
                stack.add(new AdaConstruct(current, this.fBuffer));
                current = current.Next();
            }
            this.fData = this.mergeTrees(this.fData, stack.getRootArray());
            int i = 0;
            while (i < this.fData.length) {
                this.fData[i].groupChildren();
                ++i;
            }
            this.fireElementsModifs();
            adaConstructArray = this.fData;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        return adaConstructArray;
    }

    private AdaConstruct[] mergeTrees(AdaConstruct[] oldTree, AdaConstruct[] newTree) {
        int indexOld = 0;
        int indexNew = 0;
        LinkedList<AdaConstruct> result = new LinkedList<AdaConstruct>();
        while (indexOld < oldTree.length || indexNew < newTree.length) {
            if (indexOld >= oldTree.length) {
                while (indexNew < newTree.length) {
                    result.add(newTree[indexNew]);
                    this.fElementsModified.add(new Operation(0, newTree[indexNew]));
                    ++indexNew;
                }
                continue;
            }
            if (indexNew >= newTree.length) {
                while (indexOld < oldTree.length) {
                    this.fElementsModified.add(new Operation(1, oldTree[indexOld]));
                    ++indexOld;
                }
                break;
            }
            if (oldTree[indexOld].getName().equals(newTree[indexNew].getName())) {
                result.add(oldTree[indexOld]);
                oldTree[indexOld].setChildren(this.mergeTrees(oldTree[indexOld].getChildren(null), newTree[indexNew].getChildren(null)));
                if (oldTree[indexOld].needsAdaptation(newTree[indexNew])) {
                    oldTree[indexOld].adapt(newTree[indexNew]);
                    this.fElementsModified.add(new Operation(2, oldTree[indexOld]));
                }
                ++indexNew;
                ++indexOld;
                continue;
            }
            if (indexNew + 1 < newTree.length && oldTree[indexOld].getName().equals(newTree[indexNew + 1].getName())) {
                result.add(newTree[indexNew]);
                this.fElementsModified.add(new Operation(0, newTree[indexNew]));
                ++indexNew;
                continue;
            }
            this.fElementsModified.add(new Operation(1, oldTree[indexOld]));
            ++indexOld;
        }
        AdaConstruct[] array = new AdaConstruct[result.size()];
        int i = 0;
        while (i < result.size()) {
            array[i] = (AdaConstruct)result.get(i);
            ++i;
        }
        return array;
    }

    public AdaConstruct[] getRoots(IAdaConstructFilterProvider constructFilter) {
        if (constructFilter == null) {
            return this.fData;
        }
        LinkedList<AdaConstruct> root = new LinkedList<AdaConstruct>();
        int i = 0;
        while (i < this.fData.length) {
            root.add(this.fData[i]);
            ++i;
        }
        LinkedList result = constructFilter.getFilter().getFilteredChildren(root);
        AdaConstruct[] ret = new AdaConstruct[result.size()];
        int index = 0;
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            AdaConstruct element;
            ret[index] = element = (AdaConstruct)iter.next();
            ++index;
        }
        return ret;
    }

    public AdaConstruct getConstructAt(AdaLocation location, IAdaConstructFilterProvider filter) {
        return this.internalGetConstructAt(location, filter, this.getRoots(filter));
    }

    private AdaConstruct internalGetConstructAt(AdaLocation location, IAdaConstructFilterProvider filter, AdaConstruct[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].include(location)) {
                AdaConstruct subElement = this.internalGetConstructAt(location, filter, elements[i].getChildren(filter));
                if (subElement == null) {
                    return elements[i];
                }
                return subElement;
            }
            ++i;
        }
        return null;
    }

    private class Operation {
        static final int ADD_OP = 0;
        static final int REMOVE_OP = 1;
        static final int MODIFY_OP = 2;
        int fOp;
        AdaConstruct fConstruct;

        public Operation(int op, AdaConstruct construct) {
            this.fOp = op;
            this.fConstruct = construct;
        }
    }

    private class ElementStack {
        LinkedList fNodes = new LinkedList();

        public void add(AdaConstruct node) {
            while (this.fNodes.size() > 0) {
                AdaConstruct head = (AdaConstruct)this.fNodes.getLast();
                if (!node.include(head)) break;
                node.add(head);
                this.fNodes.removeLast();
            }
            node.invert();
            this.fNodes.add(node);
        }

        public AdaConstruct[] getRootArray() {
            AdaConstruct[] array = new AdaConstruct[this.fNodes.size()];
            int i = 0;
            while (i < this.fNodes.size()) {
                array[i] = (AdaConstruct)this.fNodes.get(i);
                ++i;
            }
            return array;
        }
    }
}

