/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.analyzer.AdaAnalyzer;
import com.adacore.gnatbench.core.analyzer.AdaConstruct;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.jni.AdaString;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;

public class AdaDocumentBuffer
implements IDocumentListener {
    private IDocument fDocument;
    private String fContent;
    private AdaLocation fBegin;
    private AdaAnalyzer fAnalyzer;
    private AdaString fAdaString;

    public AdaDocumentBuffer(IDocument document, AdaLocation begin) {
        document.addDocumentListener((IDocumentListener)this);
        this.fBegin = begin;
        this.fDocument = document;
        this.fContent = document.get();
        this.fAnalyzer = new AdaAnalyzer();
        this.fAnalyzer.setDocumentBuffer(this);
        this.fAnalyzer.analyze();
    }

    public String getContent() {
        return this.fContent;
    }

    public String getContent(AdaLocation location) {
        if (location.getLength() == 0) {
            return "";
        }
        try {
            int offset = this.fDocument.getLineOffset(location.getEclipseLine()) + location.getEclipseColumn();
            return this.fContent.substring(offset, offset + location.getLength());
        }
        catch (BadLocationException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return "";
        }
    }

    private int getBeginEntity(int offset) {
        int offsetBegin = offset;
        while (offsetBegin > 0 && (this.fContent.charAt(offsetBegin) >= '0' && this.fContent.charAt(offsetBegin) <= '9' || this.fContent.charAt(offsetBegin) >= 'a' && this.fContent.charAt(offsetBegin) <= 'z' || this.fContent.charAt(offsetBegin) >= 'A' && this.fContent.charAt(offsetBegin) <= 'Z' || this.fContent.charAt(offsetBegin) == '_')) {
            --offsetBegin;
        }
        if (++offsetBegin > offset) {
            offsetBegin = offset;
        }
        return offsetBegin;
    }

    private int getEndEntity(int offset) {
        int offsetEnd = offset;
        while (offsetEnd < this.fContent.length() && (this.fContent.charAt(offsetEnd) >= '0' && this.fContent.charAt(offsetEnd) <= '9' || this.fContent.charAt(offsetEnd) >= 'a' && this.fContent.charAt(offsetEnd) <= 'z' || this.fContent.charAt(offsetEnd) >= 'A' && this.fContent.charAt(offsetEnd) <= 'Z' || this.fContent.charAt(offsetEnd) == '_')) {
            ++offsetEnd;
        }
        if (--offsetEnd < offset) {
            offsetEnd = offset;
        }
        return offsetEnd;
    }

    public AdaEntityReference getEntity(int offset) {
        int offsetBegin = this.getBeginEntity(offset);
        try {
            int line = this.fDocument.getLineOfOffset(offsetBegin);
            AdaLocation newLocation = AdaLocation.fromEclipse(this.fBegin.getAdaFile(), line, offsetBegin - this.fDocument.getLineOffset(line));
            newLocation.setLength(this.getEndEntity(offset) - offsetBegin + 1);
            return new AdaEntityReference(this, newLocation, offsetBegin);
        }
        catch (BadLocationException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return null;
        }
    }

    public AdaLocation getBaseLocation() {
        return this.fBegin;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fContent = event.getDocument().get();
        this.fAdaString = null;
    }

    public AdaLocation getClosestLocation(AdaLocation initialLocation, String entityName) {
        int offset = -1;
        try {
            offset = this.fDocument.getLineOffset(initialLocation.getEclipseLine()) + initialLocation.getEclipseColumn();
        }
        catch (BadLocationException badLocationException) {
            offset = this.fDocument.getLength() - 1;
        }
        if (offset >= this.fDocument.getLength()) {
            offset = this.fDocument.getLength() - 1;
        }
        int closest1 = this.fContent.indexOf(entityName, offset);
        int closest2 = this.fContent.lastIndexOf(entityName, offset);
        if (closest1 != -1 || closest2 != -1) {
            if (closest1 == -1) {
                offset = closest2;
            } else if (closest2 == -1) {
                offset = closest1;
            } else if (closest1 != -1 && closest2 != -1) {
                offset = Math.abs(offset - closest1) <= Math.abs(offset - closest2) ? closest1 : closest2;
            }
        }
        int lineNumber = 0;
        int columnNumber = 0;
        try {
            lineNumber = this.fDocument.getLineOfOffset(offset);
            columnNumber = offset - this.fDocument.getLineOffset(lineNumber);
        }
        catch (BadLocationException e1) {
            GNATbenchCorePlugin.getDefault().logError(null, e1);
        }
        return AdaLocation.fromEclipse(initialLocation.getAdaFile(), lineNumber, columnNumber);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public AdaEntityReference getEntity(AdaConstruct construct) {
        AdaLocation location = AdaLocation.fromEclipse(construct.getLocation().getAdaFile(), construct.getLineEntity(), construct.getColumnEntity());
        location.setLength(construct.getName().length());
        return new AdaEntityReference(this, location, construct.getOffsetBegin());
    }

    public int getOffset(AdaLocation location) {
        return this.getOffset(location.getEclipseLine(), location.getEclipseColumn());
    }

    public int getOffset(int lineNumber, int columnNumber) {
        try {
            return this.fDocument.getLineOffset(lineNumber) + columnNumber;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public AdaAnalyzer getAnalyzer() {
        return this.fAnalyzer;
    }

    public AdaEntityReference getEntity(AdaLocation location) {
        return this.getEntity(this.getOffset(location));
    }

    public int getCaracOffset(char caracSeeked, char caracIncrement, int offset, int step) throws BadLocationException, CaracNotFound {
        IDocumentExtension3 extension = (IDocumentExtension3)this.fDocument;
        String contentType = "";
        int i = offset;
        while (i >= 0 && i < this.fDocument.getLength()) {
            try {
                contentType = extension.getContentType("__ada_gnatbench_partitioning", i, false);
            }
            catch (BadLocationException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, e1);
                throw new CaracNotFound();
            }
            catch (BadPartitioningException e1) {
                GNATbenchCorePlugin.getDefault().logError(null, e1);
                throw new CaracNotFound();
            }
            if (contentType == "__dftl_partition_content_type") {
                char carac = this.fDocument.getChar(i);
                if (carac == caracSeeked) {
                    return i;
                }
                if (carac == caracIncrement) {
                    i = this.getCaracOffset(caracSeeked, caracIncrement, i + step, step);
                }
            }
            i += step;
        }
        throw new CaracNotFound();
    }

    public int getFirstNonWhite(int offset) {
        while (offset < this.fContent.length() && Character.isWhitespace(this.fContent.charAt(offset))) {
            ++offset;
        }
        if (offset >= this.fContent.length()) {
            return -1;
        }
        return offset;
    }

    public AdaString getAdaString() {
        if (this.fAdaString == null) {
            this.fAdaString = new AdaString(this.getContent());
        }
        return this.fAdaString;
    }

    public class CaracNotFound
    extends Exception {
        private static final long serialVersionUID = 1869190072604422939L;
    }
}

