/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core.adaeditor;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.adaeditor.AdaFileEditorInput;
import com.adacore.gnatbench.core.adaeditor.AdaPartitionScanner;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.TextEditor;

public abstract class AbstractAdaEditor
extends TextEditor {
    private IProject fProject;
    private AdaLocation fBaseLocation;
    private IDocument fDocument = null;
    private AdaDocumentBuffer fDocumentBuffer = null;

    public AbstractAdaEditor() {
        GNATbenchCorePlugin.getDefault().registerEditor(this);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public AdaLocation getBaseLocation() {
        return this.fBaseLocation;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public AdaDocumentBuffer getDocumentBuffer() {
        return this.fDocumentBuffer;
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        AdaFile adaFile;
        super.doSetInput(input);
        if (input instanceof AdaFileEditorInput) {
            AdaFileEditorInput adaFileInput = (AdaFileEditorInput)input;
            this.fBaseLocation = AdaLocation.fromGPS(AdaFile.fromOSPath(adaFileInput.getProject(), adaFileInput.getPath().toString()), 1, 1);
            this.fProject = adaFileInput.getProject();
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fBaseLocation = AdaLocation.fromEclipse(new AdaFile(fileInput.getFile()), 0, 0);
            this.fProject = fileInput.getFile().getProject();
        } else if (input instanceof IPathEditorInput) {
            IPathEditorInput pathInput = (IPathEditorInput)input;
            adaFile = AdaFile.fromOSPath(null, pathInput.getPath().toOSString());
            this.fBaseLocation = AdaLocation.fromEclipse(adaFile, 0, 0);
        } else if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)input;
            adaFile = AdaFile.fromEclipsePath(storageInput.getStorage().getFullPath().toOSString());
            this.fBaseLocation = AdaLocation.fromEclipse(adaFile, 0, 0);
        }
        this.fDocument = this.getDocumentProvider().getDocument((Object)input);
        this.fDocumentBuffer = new AdaDocumentBuffer(this.fDocument, this.fBaseLocation);
        IDocumentExtension3 extension3 = (IDocumentExtension3)this.fDocument;
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)GNATbenchCorePlugin.getDefault().getPartitionScanner(), AdaPartitionScanner.ADA_PARTITION_TYPES);
        extension3.setDocumentPartitioner("__ada_gnatbench_partitioning", (IDocumentPartitioner)partitioner);
        partitioner.connect(this.fDocument);
        GNATbenchCorePlugin.getDefault().removeBuffer(this.getBaseLocation());
    }

    public void dispose() {
        super.dispose();
        GNATbenchCorePlugin.getDefault().unregisterEditor(this);
    }
}

