/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.library.Language.Ada.Ada_Package;
import com.adacore.gnatbench.library.Language.Language_Root;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.jni.AdaString;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class GPRResourceSpy
implements IResourceChangeListener,
IResourceDeltaVisitor {
    protected boolean shouldRecomputeProjects;
    private static boolean fActivated = true;

    public static synchronized void setActivated(boolean activated) {
        fActivated = activated;
    }

    public static synchronized boolean isActivated() {
        return fActivated;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!GPRResourceSpy.isActivated()) {
            return;
        }
        this.shouldRecomputeProjects = false;
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (Exception e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
                break;
            }
            case 2: 
            case 4: {
                if (event.getResource() instanceof IProject) {
                    IProject project = (IProject)event.getResource();
                    try {
                        if (!project.hasNature(GNATbenchProjectNature.NATURE_ID)) break;
                        this.shouldRecomputeProjects = true;
                        GPRProject.setActive(project, false);
                    }
                    catch (CoreException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                    break;
                }
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (Exception e) {
                    GNATbenchCorePlugin.getDefault().logError(null, e);
                }
            }
        }
        if (this.shouldRecomputeProjects) {
            GNATbenchKernel.getDefault().fullWorkspaceRecompute();
            this.shouldRecomputeProjects = false;
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        int flags = delta.getFlags();
        int kind = delta.getKind();
        if ((kind & 3) == 0 && (flags & 0xFFFDFFFF) == 0) {
            return true;
        }
        IResource resource = delta.getResource();
        IProject prj = null;
        if (resource instanceof IFile) {
            prj = resource.getProject();
        } else if (resource instanceof IProject) {
            prj = (IProject)resource;
        }
        if (!(prj == null || prj.isOpen() && prj.hasNature(GNATbenchProjectNature.NATURE_ID))) {
            return false;
        }
        if ((kind & 2) == 0) {
            try {
                IMarker[] markers = resource.findMarkers("com.adacore.gnatbench.core.ImportedResourceMarker", false, 0);
                if (markers.length > 0) {
                    return false;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        block1 : switch (kind) {
            case 1: {
                switch (resource.getType()) {
                    case 1: {
                        this.handleFileExistence(resource);
                        break block1;
                    }
                    case 4: {
                        this.handleNewProject(resource);
                        break block1;
                    }
                }
                break;
            }
            case 2: {
                switch (resource.getType()) {
                    case 1: {
                        this.handleFileExistence(resource);
                        break block1;
                    }
                }
                break;
            }
            case 4: {
                int type = resource.getType();
                switch (type) {
                    case 1: {
                        this.handleFileChange(resource);
                        break block1;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) == 0 || !((IProject)resource).isOpen()) break block1;
                        this.handleNewProject(resource);
                        break block1;
                    }
                }
                break;
            }
        }
        return true;
    }

    protected void handleFileExistence(IResource resource) {
        String extension = resource.getFileExtension();
        if (extension != null) {
            if (extension.equalsIgnoreCase("gpr")) {
                this.shouldRecomputeProjects = true;
            } else if ((extension.equalsIgnoreCase("ads") || extension.equalsIgnoreCase("adb")) && !resource.getName().startsWith("b~")) {
                this.shouldRecomputeProjects = true;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleFileChange(IResource resource) {
        if (resource.getFileExtension() == null) return;
        if (resource.getFileExtension().equalsIgnoreCase("gpr")) {
            this.shouldRecomputeProjects = true;
            return;
        }
        if (!(resource instanceof IFile)) return;
        int semDep = LibrarySemaphore.startGPSWork();
        try {
            Virtual_File file = VFS_Package.Create((AdaString)new AdaString(resource.getLocation().toOSString()));
            Language_Root lang = GNATbenchKernel.getDefault().fLanguageHandler.Get_Language_From_File_Language(file, false);
            if (lang.equals((Object)Ada_Package.Ada_Lang())) {
                GNATbenchKernel.getDefault().reloadConstructFile(file);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDep);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDep);
    }

    protected void handleNewProject(IResource resource) {
        IProject project = (IProject)resource;
        if (!project.isOpen()) {
            return;
        }
        try {
            if (project.hasNature(GNATbenchProjectNature.NATURE_ID) && GPRProject.isRootProject(project)) {
                GPRProject.setActive(project, true);
                this.shouldRecomputeProjects = true;
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
    }
}

