/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GPSPreferencesProvider;
import com.adacore.gnatbench.core.IGPRListener;
import com.adacore.gnatbench.core.adaeditor.AdaEditorToolPreferencesProvider;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.library.ALI_Parser.ALI_Parser_Package;
import com.adacore.gnatbench.library.Entities.Abstract_Language_Handler_Record;
import com.adacore.gnatbench.library.Entities.Entities_Database;
import com.adacore.gnatbench.library.Entities.Entities_Package;
import com.adacore.gnatbench.library.Entities.LI_Handler_Record;
import com.adacore.gnatbench.library.Language.Language_Root;
import com.adacore.gnatbench.library.Language.Tree.Ada.Ada_Package;
import com.adacore.gnatbench.library.Language.Tree.Database.Construct_Database;
import com.adacore.gnatbench.library.Language.Tree.Database.Structured_File;
import com.adacore.gnatbench.library.Language.Tree.Tree_Language;
import com.adacore.gnatbench.library.Language_Handlers.Language_Handler_Record;
import com.adacore.gnatbench.library.Language_Handlers.Language_Handlers_Package;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Projects.Abstract_Registry;
import com.adacore.gnatbench.library.Projects.Error_Report;
import com.adacore.gnatbench.library.Projects.Project_Type;
import com.adacore.gnatbench.library.Projects.Registry.Project_Registry;
import com.adacore.gnatbench.library.Projects.Registry.Registry_Package;
import com.adacore.gnatbench.library.VFS.File_Array;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.jni.AdaString;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.WorkbenchJob;

public class GNATbenchKernel {
    private static GNATbenchKernel fgDefault;
    private Project_Registry fProjectRegistry;
    private Entities_Database fEntitiesDatabase;
    public Language_Handler_Record fLanguageHandler;
    private Job fConstructLoadJob;
    public Construct_Database fConstructDatabase;
    private GPRProject fWorkspaceProject;
    private LinkedList fGPRListeners = new LinkedList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() {
        int semDep = LibrarySemaphore.startGPSWork();
        try {
            this.fProjectRegistry = new Project_Registry();
            this.fConstructDatabase = new Construct_Database();
            Registry_Package.Initialize();
            this.fEntitiesDatabase = Entities_Package.Create((Project_Registry)this.fProjectRegistry);
            Language_Handler_Record.Ref langRef = new Language_Handler_Record.Ref();
            Language_Handlers_Package.Create_Handler((Language_Handler_Record.Ref)langRef);
            this.fLanguageHandler = langRef.ref;
            this.fEntitiesDatabase.Register_Language_Handler((Abstract_Language_Handler_Record)this.fLanguageHandler);
            this.fLanguageHandler.Set_Registry((Abstract_Registry)this.fProjectRegistry);
            this.fProjectRegistry.Load_Empty_Project();
            LI_Handler_Record li_handler = ALI_Parser_Package.Create_ALI_Handler((Entities_Database)this.fEntitiesDatabase, (Project_Registry)this.fProjectRegistry);
            this.fLanguageHandler.Register_Language(com.adacore.gnatbench.library.Language.Ada.Ada_Package.Ada_Lang(), Ada_Package.Ada_Tree_Lang(), li_handler);
            this.fProjectRegistry.Register_Default_Language_Extension(new AdaString("Ada"), new AdaString(".ads"), new AdaString(".adb"));
            this.fullWorkspaceRecompute();
            this.recomputePredefinedPaths();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDep);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDep);
    }

    public static GNATbenchKernel getDefault() {
        if (fgDefault == null) {
            fgDefault = new GNATbenchKernel();
            fgDefault.initialize();
        }
        return fgDefault;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reloadConstructFile(Virtual_File file) {
        int semDep = LibrarySemaphore.startGPSWork();
        try {
            Structured_File structuredFile = this.fConstructDatabase.Get_Or_Create(file, Ada_Package.Ada_Tree_Lang());
            structuredFile.Update_Contents();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LibrarySemaphore.stopGPSWork((int)semDep);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDep);
    }

    public synchronized void interruptConstructDatabaseLoad() {
        if (this.fConstructLoadJob != null) {
            this.fConstructLoadJob.cancel();
        }
    }

    public synchronized void reloadConstructDatabase() {
        if (this.fConstructLoadJob != null) {
            this.fConstructLoadJob.cancel();
        }
        if (!GNATbenchCorePlugin.getDefault().getPreferenceStore().getBoolean(AdaEditorToolPreferencesProvider.PREF_TOOLS_CODE_ASSIST)) {
            return;
        }
        final Job fOldConstructLoadJob = this.fConstructLoadJob;
        this.fConstructLoadJob = new Job("loading construct database "){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void loadFiles(File_Array files, IProgressMonitor monitor) {
                int i;
                int semDepth = LibrarySemaphore.startGPSWork();
                try {
                    i = files.First();
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
                LibrarySemaphore.stopGPSWork((int)semDepth);
                while (!monitor.isCanceled()) {
                    Object var8_10;
                    semDepth = LibrarySemaphore.startGPSWork();
                    try {
                        block14: {
                            block13: {
                                block12: {
                                    if (i <= files.Last()) break block12;
                                    break block13;
                                }
                                if (!monitor.isCanceled()) break block14;
                            }
                            var8_10 = null;
                            LibrarySemaphore.stopGPSWork((int)semDepth);
                            return;
                        }
                        Virtual_File file = files.Get_Element_At(i);
                        monitor.subTask(file.Full_Name(false).toString());
                        Language_Root lang = GNATbenchKernel.this.fLanguageHandler.Get_Language_From_File_Language(file, false);
                        if (lang.equals((Object)com.adacore.gnatbench.library.Language.Ada.Ada_Package.Ada_Lang())) {
                            Tree_Language tree_lang = GNATbenchKernel.this.fLanguageHandler.Get_Tree_Language_From_File(file, false);
                            GNATbenchKernel.this.fConstructDatabase.Get_Or_Create(file, tree_lang);
                        }
                        var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        var8_10 = null;
                        LibrarySemaphore.stopGPSWork((int)semDepth);
                        throw throwable;
                    }
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    ++i;
                    monitor.worked(1);
                }
                return;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                File_Array stdFiles;
                File_Array prjFiles;
                if (fOldConstructLoadJob != null) {
                    try {
                        fOldConstructLoadJob.join();
                    }
                    catch (InterruptedException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, e);
                    }
                }
                if (monitor.isCanceled()) {
                    return GNATbenchCorePlugin.OK_STATUS;
                }
                int semDepth = LibrarySemaphore.startGPSWork();
                try {
                    GNATbenchKernel.this.fConstructDatabase.Clear();
                    prjFiles = GNATbenchKernel.this.fProjectRegistry.Get_Root_Project().Get_Source_Files(true);
                    stdFiles = GNATbenchKernel.this.fProjectRegistry.Get_Predefined_Source_Files();
                    monitor.beginTask("Parse Ada Files", prjFiles.Length() + stdFiles.Length());
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
                {
                    Object var6_11 = null;
                }
                LibrarySemaphore.stopGPSWork((int)semDepth);
                if (!monitor.isCanceled()) {
                    this.loadFiles(prjFiles, monitor);
                }
                if (!monitor.isCanceled()) {
                    this.loadFiles(stdFiles, monitor);
                }
                semDepth = LibrarySemaphore.startGPSWork();
                try {
                    VFS_Package.Unchecked_Free((File_Array.Ref)((File_Array.Ref)prjFiles.NewObjectRef()));
                    VFS_Package.Unchecked_Free((File_Array.Ref)((File_Array.Ref)stdFiles.NewObjectRef()));
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                LibrarySemaphore.stopGPSWork((int)semDepth);
                monitor.done();
                return GNATbenchCorePlugin.OK_STATUS;
            }
        };
        this.fConstructLoadJob.schedule();
    }

    public Project_Registry getProjectRegistry() {
        return this.fProjectRegistry;
    }

    public Entities_Database getEntitiesDatabase() {
        return this.fEntitiesDatabase;
    }

    public GPRProject getWorkspaceProject() {
        return this.fWorkspaceProject;
    }

    public void recomputePredefinedPaths() {
        final Job loadPathJob = new Job("Load Ada Predefined Paths"){

            protected IStatus run(IProgressMonitor monitor) {
                GNATbenchKernel.this.computePredefinedPaths();
                GNATbenchKernel.this.reloadConstructDatabase();
                return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
            }
        };
        new WorkbenchJob("Load Ada Predefined Paths"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                loadPathJob.schedule();
                return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
            }
        }.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computePredefinedPaths() {
        String gnatls = null;
        try {
            int lineNumber;
            gnatls = GNATbenchKernel.getGNATLS(this.getWorkspaceProject());
            Process GNATLSProcess = Runtime.getRuntime().exec(String.valueOf(gnatls) + " -v");
            StringBuffer buffer = new StringBuffer();
            long date = Calendar.getInstance().getTimeInMillis();
            while (true) {
                try {
                    GNATLSProcess.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    long currentDate;
                    if ((currentDate = Calendar.getInstance().getTimeInMillis()) - date <= 10000L) continue;
                }
                break;
            }
            while (GNATLSProcess.getErrorStream().available() > 0) {
                buffer.append((char)GNATLSProcess.getErrorStream().read());
            }
            while (true) {
                if (GNATLSProcess.getInputStream().available() <= 0) break;
                buffer.append((char)GNATLSProcess.getInputStream().read());
            }
            String[] lines = buffer.toString().split("\\n");
            Pattern p_version = Pattern.compile("^GNATLS (.*)$");
            int i = 0;
            while (true) {
                if (i >= lines.length) {
                    lineNumber = 0;
                    break;
                }
                lines[i] = lines[i].replaceAll("\\n", "").replaceAll("\\r", "");
                ++i;
            }
            while (lineNumber < lines.length) {
                Matcher m_version = p_version.matcher(lines[lineNumber]);
                if (m_version.matches()) {
                    m_version.group(1);
                    ++lineNumber;
                    break;
                }
                ++lineNumber;
            }
            while (lineNumber < lines.length) {
                if (lines[lineNumber].equals("Source Search Path:")) {
                    ++lineNumber;
                    break;
                }
                ++lineNumber;
            }
            int semDepth = LibrarySemaphore.startGPSWork();
            try {
                String path;
                while (lineNumber < lines.length) {
                    if (lines[lineNumber].equals("Object Search Path:")) {
                        ++lineNumber;
                        break;
                    }
                    if (!lines[lineNumber].replaceAll(" ", "").equals("<Current_Directory>") && !lines[lineNumber].equals("")) {
                        path = lines[lineNumber].replaceAll("^ *", "");
                        this.fProjectRegistry.Set_Predefined_Source_Path(new AdaString(path));
                    }
                    ++lineNumber;
                }
                while (lineNumber < lines.length) {
                    block22: {
                        if (!lines[lineNumber].equals("Project Search Path:")) break block22;
                        ++lineNumber;
                        break;
                    }
                    if (!lines[lineNumber].replaceAll(" ", "").equals("<Current_Directory>") && !lines[lineNumber].equals("")) {
                        path = lines[lineNumber].replaceAll("^ *", "");
                        this.fProjectRegistry.Set_Predefined_Object_Path(new AdaString(path));
                    }
                    ++lineNumber;
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                LibrarySemaphore.stopGPSWork((int)semDepth);
                throw throwable;
            }
            {
                Object var11_18 = null;
            }
            LibrarySemaphore.stopGPSWork((int)semDepth);
            GNATLSProcess.destroy();
            return;
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            String message = gnatls == null || gnatls.equals("") ? "The 'gnatls' command preference is not set.\n\n" : "The 'gnatls' command \"" + gnatls + "\" cannot be launched.\n\n";
            final String finalMessage = message = String.valueOf(message) + "The command name should be based on your installed compiler,\ne.g., powerpc-wrs-vxworks-gnatls or powerpc-elf-gnatls.\n\nYou can set this command name in the\"External Commands\"\npage of the Ada preferences.";
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    new MessageDialog(null, "Computing Ada Paths", null, finalMessage, 2, new String[]{"Ok"}, 0).open();
                }
            });
            return;
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fullWorkspaceRecompute() {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            try {
                Iterator iter;
                GPRProject.incrementTimestamp();
                this.fProjectRegistry.Load_Empty_Project();
                this.fProjectRegistry.Recompute_View(new Error_Report(){

                    public void Error_Report_Body(AdaString Msg) {
                        GNATbenchCorePlugin.getDefault().logError(Msg.toString(), null);
                    }
                });
                this.fWorkspaceProject = GPRProject.getRoot();
                IProject[] tabProject = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                this.fWorkspaceProject = GPRProject.getRoot();
                int i = 0;
                while (true) {
                    if (i >= tabProject.length) {
                        this.fWorkspaceProject.recompute();
                        this.recomputePredefinedPaths();
                        iter = this.fGPRListeners.iterator();
                        break;
                    }
                    if (GPRProject.isRootProject(tabProject[i])) {
                        this.fWorkspaceProject.addDependency(tabProject[i]);
                    }
                    ++i;
                }
                while (iter.hasNext()) {
                    IGPRListener element = (IGPRListener)iter.next();
                    element.workspaceRecomputed();
                }
            }
            catch (GNATbenchCoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public void addGPRListener(IGPRListener listener) {
        this.fGPRListeners.add(listener);
    }

    public void removeGPSListener(IGPRListener listener) {
        this.fGPRListeners.remove(listener);
    }

    public static String getGNATLS(GPRProject prj) throws GNATbenchCoreException {
        String gnatls = null;
        Project_Type[] deps = prj.getDependencies(false);
        String extractedGnatls = prj.getAttributeValue("Gnatlist", "Ide", "");
        if (extractedGnatls != null && !extractedGnatls.equals("")) {
            return extractedGnatls;
        }
        int j = 0;
        while (j < deps.length) {
            extractedGnatls = new GPRProject(deps[j], deps[j].Project_Name_String().toString()).getAttributeValue("Gnatlist", "Ide", "");
            if (extractedGnatls != null && !extractedGnatls.equals("")) {
                if (gnatls == null) {
                    gnatls = extractedGnatls;
                } else if (!gnatls.equals(extractedGnatls)) {
                    final String toolchain1 = gnatls;
                    final String toolchain2 = extractedGnatls;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            new MessageDialog(null, "Computing Ada Paths", null, "Inconsistency between the toolchains \"" + toolchain1 + "\" and " + "\"" + toolchain2 + "\" given by" + " two different projects. " + "A workspace must" + " have only one consistent " + "toolchain set among projects.", 1, new String[]{"Ok"}, 0).open();
                        }
                    });
                    return "";
                }
            }
            ++j;
        }
        if (gnatls == null || gnatls.equals("")) {
            gnatls = GNATbenchCorePlugin.getDefault().getPreferenceStore().getString(GPSPreferencesProvider.PREF_GNATLS_LAUNCH_COMMAND);
        }
        return gnatls;
    }
}

