/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.core;

import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.GPRResourceSpy;
import com.adacore.gnatbench.core.adaeditor.AbstractAdaEditor;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.adaeditor.AdaPartitionScanner;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.preferences.IGNATbenchPreferencesProvider;
import com.adacore.gnatbench.library.Language.Indent_Parameters;
import com.adacore.gnatbench.library.LibrarySemaphore;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class GNATbenchCorePlugin
extends AbstractUIPlugin {
    private static GNATbenchCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private HashMap fBuffers = new HashMap();
    private AdaPartitionScanner fPartitionScanner;
    private LinkedList fEditors = new LinkedList();
    public static final String ADA_PARTITIONING = "__ada_gnatbench_partitioning";
    public static final String ADA_LOCATION_MARKER = "com.adacore.gnatbench.core.AdaLocationMarker";
    public static final String ADA_ERROR_MARKER = "com.adacore.gnatbench.core.AdaErrorMarker";
    public static final String GPR_ERROR_MARKER = "com.adacore.gnatbench.core.GPRErrorMarker";
    public static final String ADA_IMPORT_MARKER = "com.adacore.gnatbench.core.ImportedResourceMarker";
    public static final Status OK_STATUS;
    private Indent_Parameters fIndentParams;

    static {
        OK_STATUS = new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GNATbenchCorePlugin() {
        plugin = this;
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            this.fIndentParams = new Indent_Parameters();
            this.fIndentParams.Indent_Level(3);
            this.fIndentParams.Indent_Continue(2);
            this.fIndentParams.Indent_Conditional(1);
            this.fIndentParams.Indent_Record(3);
            this.fIndentParams.Indent_Decl(0);
            this.fIndentParams.Tab_Width(8);
            this.fIndentParams.Indent_Case_Extra(0);
            this.fIndentParams.Casing_Policy(0);
            this.fIndentParams.Reserved_Casing(0);
            this.fIndentParams.Ident_Casing(0);
            this.fIndentParams.Format_Operators(false);
            this.fIndentParams.Use_Tabs(false);
            this.fIndentParams.Align_On_Colons(false);
            this.fIndentParams.Align_On_Arrows(false);
            this.fIndentParams.Align_Decl_On_Colon(false);
            this.fIndentParams.Indent_Comments(true);
            this.fIndentParams.Stick_Comments(false);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
        {
            this.resourceBundle = ResourceBundle.getBundle("com.eclipse.adacore.gnatbench.core.GnatbenchPluginResources");
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new GPRResourceSpy());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        GNATbenchKernel.getDefault();
    }

    public Indent_Parameters getIndentParameters() {
        return this.fIndentParams;
    }

    public static GNATbenchCorePlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void notifyError(String error) {
        this.notifyError(error, null);
    }

    public void notifyError(String error, Exception e) {
    }

    public static String getId() {
        return "com.adacore.gnatbench.core";
    }

    public String getPluginPath() {
        try {
            String path = Platform.asLocalURL((URL)this.getBundle().getEntry("/")).getPath();
            if (Platform.getOS().equals("win32")) {
                return path.substring(1);
            }
            return path;
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return "";
        }
    }

    public void delay(int milisec) {
        Job j = new Job("delay job"){

            protected IStatus run(IProgressMonitor monitor) {
                return new Status(0, GNATbenchCorePlugin.getId(), 0, "", null);
            }
        };
        j.schedule((long)milisec);
        try {
            j.join();
        }
        catch (InterruptedException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
    }

    public AdaDocumentBuffer getDocumentBuffer(AdaLocation location) {
        AbstractAdaEditor editor = this.getEditor(location);
        if (editor != null) {
            return editor.getDocumentBuffer();
        }
        AdaDocumentBuffer buffer = (AdaDocumentBuffer)this.fBuffers.get(location.getAdaFile().getEclipsePath());
        if (buffer != null) {
            return buffer;
        }
        Document document = new Document();
        try {
            FileInputStream fileInput = new FileInputStream(location.getAdaFile().getOSPath());
            String result = "";
            byte[] byteBuffer = new byte[2048];
            int nbRed = 0;
            while ((nbRed = fileInput.read(byteBuffer)) > 0) {
                result = String.valueOf(result) + new String(byteBuffer, 0, nbRed);
            }
            document.set(result);
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)this.getPartitionScanner(), AdaPartitionScanner.ADA_PARTITION_TYPES);
            document.setDocumentPartitioner(ADA_PARTITIONING, (IDocumentPartitioner)partitioner);
            partitioner.connect((IDocument)document);
        }
        catch (FileNotFoundException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
        catch (IOException e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
        }
        buffer = new AdaDocumentBuffer((IDocument)document, location);
        this.fBuffers.put(location.getAdaFile().getEclipsePath(), buffer);
        return buffer;
    }

    public AbstractAdaEditor getEditor(AdaLocation location) {
        Iterator iter = this.fEditors.iterator();
        while (iter.hasNext()) {
            AbstractAdaEditor editor = (AbstractAdaEditor)((Object)iter.next());
            if (!location.getAdaFile().getEclipsePath().equals(editor.getBaseLocation().getAdaFile().getEclipsePath())) continue;
            return editor;
        }
        return null;
    }

    public AbstractAdaEditor getEditor(IFile file) {
        Iterator iter = this.fEditors.iterator();
        while (iter.hasNext()) {
            AbstractAdaEditor editor = (AbstractAdaEditor)((Object)iter.next());
            if (!file.equals((Object)editor.getBaseLocation().getAdaFile().getFile())) continue;
            return editor;
        }
        return null;
    }

    public AdaPartitionScanner getPartitionScanner() {
        if (this.fPartitionScanner == null) {
            this.fPartitionScanner = new AdaPartitionScanner();
        }
        return this.fPartitionScanner;
    }

    public void removeBuffer(AdaLocation location) {
        this.fBuffers.remove(location.getAdaFile().getEclipsePath());
    }

    public void registerEditor(AbstractAdaEditor editor) {
        this.fEditors.add(editor);
    }

    public void unregisterEditor(AbstractAdaEditor editor) {
        this.fEditors.remove((Object)editor);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(), "preference");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return;
        }
        int extInd = 0;
        while (extInd < extensions.length) {
            IConfigurationElement[] elements = extensions[extInd].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("provider")) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[extInd].getNamespace());
                        IGNATbenchPreferencesProvider preferenceProvider = (IGNATbenchPreferencesProvider)bundle.loadClass(elements[i].getAttribute("class")).newInstance();
                        preferenceProvider.initializeDefaultPreferences(store);
                    }
                    catch (InvalidRegistryObjectException e) {
                        this.logError(null, e);
                    }
                    catch (InstantiationException e) {
                        this.logError(null, e);
                    }
                    catch (IllegalAccessException e) {
                        this.logError(null, e);
                    }
                    catch (ClassNotFoundException e) {
                        this.logError(null, e);
                    }
                }
                ++i;
            }
            ++extInd;
        }
    }

    public void createPreferenceFields(AdaPreferencePage page) {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin.getId(), "preference");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return;
        }
        int extInd = 0;
        while (extInd < extensions.length) {
            IConfigurationElement[] elements = extensions[extInd].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("provider")) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[extInd].getNamespace());
                        String id = elements[i].getAttribute("pageId");
                        if (id.equals(page.getId())) {
                            IGNATbenchPreferencesProvider preferenceProvider = (IGNATbenchPreferencesProvider)bundle.loadClass(elements[i].getAttribute("class")).newInstance();
                            preferenceProvider.createPreferenceFields(page);
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        this.logError(null, e);
                    }
                    catch (InstantiationException e) {
                        this.logError(null, e);
                    }
                    catch (IllegalAccessException e) {
                        this.logError(null, e);
                    }
                    catch (ClassNotFoundException e) {
                        this.logError(null, e);
                    }
                }
                ++i;
            }
            ++extInd;
        }
    }

    public void logError(String message, Throwable exception) {
        if (message == null && exception == null) {
            return;
        }
        if (message == null) {
            message = "UnexpectedException";
        }
        this.getLog().log((IStatus)new Status(4, GNATbenchCorePlugin.getId(), 0, message, exception));
    }
}

