#! /usr/bin/env python

# xspack

# Generate s-pack*.{ads,adb} from templates s-pack.ads.tmpl and s-pack.adb.tmpl

import re
import sys

tmpl_base = "s-pack.ad%c.tmpl"


def read_template(part):
    return open(tmpl_base % part).readlines()


def output(pkg, bits, part):
    global tmpl

    bits_str_pad = "%02d" % bits
    bits_str_dbl = "%d %d" % (bits / 10, bits % 10)
    bits_str = "%d" % bits

    out = open(pkg % (bits, part), 'w')
    skip = False

    for l in tmpl[part]:
        if l.find('@even') == 0 and bits % 2 == 1:
            skip = True
        if l.find('@/even') == 0:
            skip = False
        if l[0] != '@' and not skip:
            l = l.replace('@@', bits_str_pad)
            l = l.replace('@ @', bits_str_dbl)
            l = l.replace('@', bits_str)
            out.write(l)

parts = ['s', 'b']
tmpl = {}

for part in parts:
    tmpl[part] = read_template(part)

for bits in range(3, 64):
    if bits & (bits - 1) == 0:
        # Power of two: no package generated
        continue

    pkg_base = "s-pack%02d.ad%c"
    for part in parts:
        output(pkg_base, bits, part)
